/*
 * Copyright (C) 2013 gsfan, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/* Copyright (C) 2014 Wiznet, MIT License
 *  port to the Wiznet Module WizFi250
 */
/* Copyright (C) 2017 Wiznet, MIT License
 *  port to the Wiznet Module WizFi310
 */

#include "WizFi310.h"

bool WizFi310::startup(void)
{
    reset();

    for(int i=0;i<10;i++)
    {
        if( cmdAT() == 0 ) break;
    }
    if( cmdMECHO(false) == -1)  return false;
    //if( cmdMECHO(true) == -1) return false;
    if(_cts != NULL && _rts != NULL)
    {
        if( cmdUSET(_baud,"HW") == -1)  return false;
    }
    else
    {
        if( cmdUSET(_baud,"N") == -1)   return false;
    }
    wait_ms(1000);
    if( cmdAT() == -1)          return false;

    return true;
}

bool WizFi310::reset(void)
{
    _reset = 0;
    wait_ms(500);
    _reset = 1;

    return true;
}
