#include "mbed.h"
#include "EthernetInterface.h"
#include "Adafruit_SSD1306.h"

#define TOKEN "904626807491530753-sOaChz44g9YFS7EuvRkR75l1W9T303K"
//#define TOKEN "UserToken"

// an SPI sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};

I2CPreInit gI2C(PA_10,PA_9);
Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);


int main()
{
        int phy_link;
         printf("................................Tweeting Machine Program..........................\r\n\r\n");
        //--------- Have to modify the mac address-------------
        uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x03, 0x04, 0x22}; 
        
        EthernetInterface eth;
        eth.init(mac_addr); //Use DHCP
            
        eth.connect();
        
        while(1){
                
            /* phy link */
             while(!phy_link){
                printf("Failed to obtain IP Adress\r\n\r\n");
                phy_link = eth.ethernet_link();
                printf("...");
                wait(2);
            }
            printf("\r\n");
            printf("IP Adress obtained\r\n\r\n");    
            printf("IP Address is: %s\r\n", eth.getIPAddress());
             while(1){ 
            /* TCP socket connect */
            TCPSocketConnection sock;
            sock.connect("arduino-tweet.appspot.com", 80);
            if(sock.is_connected())
            {
                printf("\r\nConnected to the DNS Server\r\n\r\n");
            }
            else
            {
                printf("\r\nDNS Server connection error\r\n\r\n");
            }
            /* typing message */        
            printf("Type your tweet:");
            
           char* message;
            scanf("%s",message);   
            printf("%s",message);
            printf("\r\n\r\n");
           
            int len = strlen(message);
            
            /* data length measure */
            char data_len[2]={0};
            int ten=0;
            int one=0;
            
            int length = len + sizeof(TOKEN) - 1 + 14;
            
            printf("length : %d\r\n\r\n",length);
            
            ten = length/10;
            one = length%10;
            data_len[1] = one + 48;
            data_len[0] = ten + 48;
        
        
            char send_data[1024];
            char buffer[1024] = {0};
              sprintf(send_data, "GET http://arduino-tweet.appspot.com/update?token=%s&status=%s\r\n",TOKEN,message);
    
             if(sock.send_all(send_data, sizeof(send_data))!=-1)
            {
                printf("The sent URL is: %s\r\n",send_data);
                printf("The sent Tweet is: %s",message);
                printf("\r\nMessage sent successfully\r\n\r\n");
            }
            else
            {
                printf("\r\nMessage sending failed\r\n\r\n");
            }
            printf("Response from the server:\r\n\r\n");
            sock.receive(buffer, sizeof(buffer));
    
            printf("%s\r\n",buffer); 
            gOled.begin();
            gOled.printf("%s\r\n",message);
            gOled.display();
    
            wait(70.0);
            
            gOled.clearDisplay();
            
            //sock.close();
            //eth.disconnect();
            
    };

}
}