#include "mbed.h"
#define PI 3.1415

Timer     t;

AnalogIn   ain_v1(p20); // Input voltage from antenna


int main()
{
    float v1, m, b, p_in, Pt, Gt, Gr, Pr, f, c, r;
    
    t.start();
    while(t.read()<10.0)
    {
    // Voltage to Power calculations
    v1      = ain_v1;           // ain_v1;   // Comes from mBed (Can adjust manually for now)
    b       = 2.095;            // (volts) Direct function generator measurement
    m       = .0316;            // volts/dBm (Calculated at 2000 MHz and 0 and -40 dBm)
    p_in    = (v1-b)/m;         // Derived from v = m*p+b (linear relationship of voltage and power)
   
    // Range equation Terms
    Pt      = .001;             //(watts or 1mW or 0 dBm) Power Transmitted. This is ~16 dBm (.0398 watts) for an iphone 5
    Gt      = 1;                // Unitless (1 for FG)                      Shouldn't both of these gains be 'directive' gains, not power gains
    Gr      = .007;                // (.007) (7 mW) How do we get this? Should be on datasheet... but calc required? 7 milliwatt?
    Pr      = pow(10, ((p_in-30)/10)); // (watts)
    
    // Free Space Loss Terms
    f       = 2000000000;       // (Hz) This will be constant for a phone... but what to put for the FG
    c       = 300000000;        // m/s
    
    r       = (c*(sqrt(Pt*Gt*Gr)/Pr))/(4*PI*f);
    
    //printf("\rRange  (meters) = %.3f\n\r",r);
    //printf("Power    (watts) = %.4f\n\r",Pr);
    printf("Voltage into mBed = %.4f\n\r",v1);
    }
}





