#include "mbed.h"
#define PI 3.1415
#include "C12832.h"
#include "Servo.h"


LocalFileSystem local("local");               // Create the local filesystem under the name "local"

C12832 lcd(p5, p7, p6, p8, p11);

Timer     t;

AnalogIn    ain_v1(p19);        // Input voltage from antenna
Servo      servo(p21);         // Input commands and power for servo (Three PWM1 pins correspond to pin 21)

    // Global variables declared
    float v1, m, b, p_in, Pt, Gt, Gr, Pr, Pr_scaled, f, c, r, offset;
    float lv_r[250], lv_v1[250], lv_PrS[250], lv_time[250];
    int k, n;

int main()
{
    n = 250;
    servo.calibrate(0.00045, 45.0); // Halfway point (first number is some sort of control frequency)
    
    //logging setup 
    for(k=0;k<n;k++)
     { 
        lv_r[k]         = 0.0;
        lv_v1[k]        = 0.0;
        lv_PrS[k]       = 0.0;
        lv_time[k]      = 0.0;
     }
    k = 0;
    
    
    
    t.start();
    while(k<250)//=================================================================================================
    {
        
    // SENSE=============
    
    // Voltage to Power calculations
    v1      = ain_v1*3.33;          // 3.3 is for scaling voltage properly... ask Feemster why this is necessary.
    b       = 2.095;                // (volts) Direct function generator measurement
    m       = .0316;                // volts/dBm (Calculated at 2000 MHz and 0 and -40 dBm)
    p_in    = (v1-b)/m;             // Derived from v = m*p+b (linear relationship of voltage and power)
   
    // Range equation Terms
    Pt          = .0398;                    // (Watts) For iPhone 5
    Gt          = .707;                     // sqrt(2)/2
    Gr          = .007;                     // Approximation (Will calibrate in antenna chamber) 
    Pr          = pow(10, ((p_in-30)/10));  // (watts)
    Pr_scaled   = Pr*1000;
    
    // Free Space Loss Terms
    f       = 800000000;            // (Hz) This will be constant for a phone... but what to put for the FG
    c       = 300000000;            // m/s
    
    r       = (c*sqrt(Pt*Gt*Gr/Pr))/(4*PI*f);
    
    //DECIDE=============
    
    if(r<=7.0)
    {   
        wait(0.2);
        servo = .088;           // 0 to 1 where 1 is 90 degrees due to calibration command above
    }
    
    if(r>=8.0 && r<=10.0)
    {   
        wait(0.2);
        servo = .33;            // Above
    }
    
    if(r>11.0 && r<=13.0)
    {   
        wait(0.2);
        servo = .55;            // Above
    }
    
    
    printf("\rRange (meters)    = %.3f\n\r",r);
    printf("Power (mW)        = %.3f\n\r",Pr_scaled);
    printf("Voltage into mBed = %.4f\n\r",v1);
    // Can print time if desired
    
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Voltage (volts) = %.4f",v1);
    
    lcd.locate(0,15);
    lcd.printf("Range (meters) = %.4f",r);
    
    //LOG stuff
    if(k<n)
    {   lv_r[k]     = r;
        lv_v1[k]    = v1;
        lv_PrS[k]   = Pr;
        lv_time[k]  = t;
        k++;
    }
    
    } // End of while=======================================================
    
    // Open logging file (Must be done down here... not sure why)
    FILE *fp = fopen("/local/mBedOutp.m", "w"); 
    
    if(1)
    {
    
    for(k=0;k<n;k++)
    {   fprintf(fp,"lv.r(%d,1)  = %.3f;\n",k+1,lv_r[k]);
        fprintf(fp,"lv.v1(%d,1) = %.4f;\n",k+1,lv_v1[k]);
        fprintf(fp,"lv.PrS(%d,1) = %.8f;\n",k+1,lv_PrS[k]);
        fprintf(fp,"lv.t(%d,1) = %.4f;\n",k+1,lv_time[k]);
    }
    
    }// End of IF loop
    
    fclose(fp);
} // End of main loop=======================================================