#include "mbed.h"
#define PI 3.1415
#include "C12832.h"

LocalFileSystem local("local");               // Create the local filesystem under the name "local"

C12832 lcd(p5, p7, p6, p8, p11);

Timer     t;

AnalogIn   ain_v1(p19); // Input voltage from antenna

    // Global variables declared
    float v1, m, b, p_in, Pt, Gt, Gr, Pr, f, c, r;
    float lv_r[250], lv_v1[250];
    int k;

int main()
{
    
    // Open logging file
    FILE *fp = fopen("/local/mBedOutp.m", "w"); 
    
    //logging setup 
    for(k=0;k<250;k++)
     { 
        lv_r[k]      = 0.0;
        lv_v1[k]     = 0.0;
     }
    k = 0;
    
    t.start();
    while(k<250)
    {
    // Voltage to Power calculations
    v1      = ain_v1*3.33;           // ain_v1;   // Comes from antenna (Can adjust manually for now) (3.3 is for scaling voltage properly... ask Feemster why this is necessary.
    b       = 2.095;            // (volts) Direct function generator measurement
    m       = .0316;            // volts/dBm (Calculated at 2000 MHz and 0 and -40 dBm)
    p_in    = (v1-b)/m;         // Derived from v = m*p+b (linear relationship of voltage and power)
   
    // Range equation Terms
    Pt      = .0398;            //(watts or 1mW or 0 dBm) Power Transmitted. This is ~16 dBm (.0398 watts) for an iphone 5
    Gt      = 1;                // Unitless (1 for FG)                      Shouldn't both of these gains be 'directive' gains, not power gains
    Gr      = .007;                // (.007) (7 mW) How do we get this? 7 milliwatt?
    Pr      = pow(10, ((p_in-30)/10)); // (watts)
    
    // Free Space Loss Terms
    f       = 2400000000;       // (Hz) This will be constant for a phone... but what to put for the FG
    c       = 300000000;        // m/s
    
    r       = (c*(sqrt(Pt*Gt*Gr)/Pr))/(4*PI*f);
    
    printf("\rRange (meters)    = %.3f\n\r",r);
    //printf("Power (watts)     = %.3f\n\r",Pr);
    printf("Voltage into mBed = %.4f\n\r",v1);
    //printf("%.4f\n\r",v1);
    
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Voltage (volts) = %.4f",v1);
    
    lcd.locate(0,15);
    lcd.printf("Range (meters) = %.4f",r);
    
      //LOG stuff
    if(k<250)
    {   lv_r[k]     = r;
        lv_v1[k]    = v1;
        k++;
    }
    
    } // End of while=======================================================
    
    if(1)
    {
    
    for(k=0;k<250;k++)
    {   fprintf(fp,"lv.r(%d,1)  = %.3f;\n",k+1,lv_r[k]);
        fprintf(fp,"lv.v1(%d,1) = %.4f;\n",k+1,lv_v1[k]);
    }
    
    }// End of IF loop
    
    fclose(fp);
} // End of main loop=======================================================