#include "mbed.h"
#include "mbed_rpc.h"

//using namespace mbed;

Serial pc(USBTX, USBRX);

float num = 0;

RPCVariable<float> rpc_num(&num, "num");

int main() {
    // setup the classes that can be created dynamically
    
    //These exist for all platforms
    RPC::add_rpc_class<RpcDigitalIn>();
    RPC::add_rpc_class<RpcDigitalOut>();
    RPC::add_rpc_class<RpcDigitalInOut>();
    RPC::add_rpc_class<RpcTimer>();
    
    //Others are conditional by platform
    
    //Unknown how RPC would work if serial was not present?
    #if DEVICE_SERIAL
    RPC::add_rpc_class<RpcSerial>();
    #else
    #warning "No Serial function available in this configuration."
    #endif
    
    #if DEVICE_ANALOGIN
    RPC::add_rpc_class<RpcAnalogIn>();
    #else
    #warning "No AnalogIn function available in this configuration."
    #endif
    
    #if DEVICE_ANALOGOUT
    RPC::add_rpc_class<RpcAnalogOut>();
    #else
    #warning "No AnalogOut function available in this configuration."
    #endif
    
    #if DEVICE_PWMOUT
    RPC::add_rpc_class<RpcPwmOut>();
    #else
    #warning "No PWMOut function available in this configuration."
    #endif
    
    #if DEVICE_SPI
    RPC::add_rpc_class<RpcSPI>();
    #else
    #warning "No SPI function available in this configuration."
    #endif
    
    //These appear to not be implemented
    //RPC::add_rpc_class<BusOut>();
    //RPC::add_rpc_class<RpcBusIn>();
    //RPC::add_rpc_class<RpcBusInOut>();
    
    // receive commands, and send back the responses
    char buf[RPC_MAX_STRING], outbuf[RPC_MAX_STRING];
    while(1) {
        pc.gets(buf, RPC_MAX_STRING);
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
    
}
