#include "mbed.h"
#include "EthernetInterface.h"
#include <string>
#include <sstream> 
#include "oJSON.h"
#include "rtos.h"

float light_thresh = 0.1;


DigitalOut myled(LED1);
DigitalOut cs(p8);
DigitalOut P11(p11); // Device 1 control, obtained from database server
DigitalOut P12(p12); // Device 2 control, obtained from database server
DigitalOut P13(p13); // Device 3 control, obtained from database server
DigitalOut P14(p14); // Device 4 control, obtained from database server
DigitalOut P15(p15); // Manual / Automatic mode ( 0 / 1 ) , obtained from database server
DigitalOut P16(p16); // Security feature ( off / on - 0 / 1 ) , obtained from database server
DigitalOut P17(p17); // Near / Far (The user is near / far from home based on GPS location, obtained from database server, near / far - 0 / 1 ) 
DigitalIn P18(p18);  // Used for data transfer synchronization between 2 mbeds
DigitalOut P19(p19); // Used for data transfer synchronization between 2 mbeds
DigitalOut led1(LED1); // blinks when transferring data to the other mbed
DigitalOut led2(LED2); 
DigitalOut led3(LED3); 
DigitalOut led4(LED4);  
Mutex lock_mutex;
extern "C" void mbed_reset();
int x;
EthernetInterface eth;
int global_var=0;
Serial pc(USBTX, USBRX);
void replaceAll(std::string& str, const std::string& from, const std::string& to) {
    size_t start_pos = 0;
    while((start_pos = str.find(from, start_pos)) != std::string::npos) {
      
        size_t end_pos = start_pos + from.length();
        str.replace(start_pos, from.length(), to);
        start_pos += to.length(); // In case 'to' contains 'from', like replacing 'x' with 'yx'
    }
}

// Thread for connecting to the database server, accessing the data (control signals) and then sending it to the other mbed
void thread_server_ping(void const *args)
{
   string lat_1;
   string lon_1;
   stringstream st;
   string ss;
   pc.printf("Connecting...\n");  
   pc.printf("IP Address is %s\n", eth.getIPAddress());
   lock_mutex.lock();
   TCPSocketConnection sock;
   x = sock.connect("dev.m.gatech.edu", 80);
   lock_mutex.unlock();
   if(x!=0)
        mbed_reset();
   pc.printf("Return Value: %d\n", x);
   pc.printf("\n\n\n Accessing Database Server \n\n");
   char http_cmd[] = "GET /d/rsrs3/w/SilentGardian/c/api/gpsLocation/ HTTP/1.0\n\n";
    lock_mutex.lock();
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    lock_mutex.unlock();
    char *buffer;
    char *buffer2;
    buffer = (char *)malloc (sizeof(char)*3000);
    buffer2 = (char *)malloc (sizeof(char)*3000);
   
    string str;
    int ret;
        pc.printf("Waiting to receive data..\n");
        lock_mutex.lock();
        sock.set_blocking(false,7500);
        ret = sock.receive(buffer, (sizeof(char)*3000)-1);
        lock_mutex.unlock();
        st << buffer; 
        st >> ss;
        
        
        
        if (ret <= 0)
        {
           // pc.printf("Ret <=0, break here \n");
           pc.printf("... \n");
            //break;
            mbed_reset();
            terminate();
        }
        buffer[ret] = '\0';
        int cnt=0;
        char tmp;
        while (tmp!='[')
        {
            cnt++;
            tmp=buffer[cnt];
             
        }
        int i=cnt;
        for(i=cnt;i<ret;i++)
        {
            buffer2[i-cnt]=buffer[i];
            if(buffer[i]==']')
                break;
        }
        buffer2[i-cnt+1]=buffer[ret];
        pc.printf("Received %d chars from server:\n", ret);
     str=string(buffer2);
   string str2 = "";
   const char *cstr=str.c_str();
   for(int i=0;i<str.size();i++)
   {
        char a=cstr[i];
        if(a!='_')
        {
            str2= str2 + a;   
        }
    }
    JSONArray *j= new JSONArray(str2);
    JSONArray j1= j->getArray(0);
    string s1=j1.getString(1);
     
    int ind=s1.find(":\"", 0); 
    ind = ind + 2; 
    string s11=s1.substr(ind,s1.length());
    string s2=j1.getString(2);
    string s0=j1.getString(0);

    int ind2=s2.find(":\"", 0); 
     ind2 = ind2 + 2; 
     string s22=s2.substr(ind,s2.length());
     int control_sig=atoi(s11.c_str()); 
     int d1to4=atoi(s22.c_str());    
     pc.printf("JSON parsing : d1to d4 values:%d, \n control_sig value:%d\n",d1to4,control_sig);
        P15=1;
        P11=(int)((d1to4>>3) & 1);
        P12=(int)((d1to4>>2) & 1);
        P13=(int)((d1to4>>1) & 1);
        P14=(int)((d1to4>>0) & 1);
        P15=(int)((control_sig>>2) & 1);
        P16=(int)((control_sig>>1) & 1);
        P17=(int)((control_sig>>0) & 1);
        
        P19=0;
        int P111=(int)((d1to4>>3) & 1);   // Device 1 control, obtained from database server
        int P112=(int)((d1to4>>2) & 1);   // Device 2 control, obtained from database server
        int P113=(int)((d1to4>>1) & 1);   // Device 3 control, obtained from database server
        int P114=(int)((d1to4>>0) & 1);   // Device 4 control, obtained from database server
        int P115=(int)((control_sig>>2) & 1);  // Manual / Automatic mode ( 0 / 1 ) , obtained from database server
        int P116=(int)((control_sig>>1) & 1);  // Security feature ( off / on - 0 / 1 ) , obtained from database server
        int P117=(int)((control_sig>>0) & 1);  // Near / Far (The user is near / far from home based on GPS location, obtained from database server, near / far - 0 / 1 ) 
        
          pc.printf("P11: %d, P12: %d, P13: %d, P14:%d, P15:%d, P16:%d, P17:%d, P19: %d \n",(int)P11,(int)P12,(int)P13,(int)P14,(int)P15,(int)P16,(int)P17,(int)P19);
         
        while(P18==1)
        {
            
        }
        P19=1;
         myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    sock.close();  
   
    delete buffer;
    delete buffer2;
    mbed_reset();
    terminate();
    while(1) {
   
       }   
}

int main() {
       P19=1;
       P18.mode(PullUp);
      eth.init(); //Use DHCP
    eth.connect();
    TCPSocketConnection sock;

         pc.printf("IP Address is %s\n", eth.getIPAddress());
    lock_mutex.lock();
   x = sock.connect("dev.m.gatech.edu", 80);    // Connect to the database server
    lock_mutex.unlock();
    Thread *ping_server=new Thread(thread_server_ping);     //Start thread which fetches data from database server
    
    global_var=1;
   while(1){
        Thread::wait(30000);
        ping_server->terminate();
             lock_mutex.unlock();
            pc.printf("New thread started \n");
             ping_server=new Thread(thread_server_ping);
       }
}
