#include "mbed.h"
#include "rtos.h"
AnalogIn light_1(p20); //light sensor
AnalogIn proxi_2(p15); // for detecting motion within the house
DigitalIn proxi_1(p5); // for security
DigitalOut relay_1(p8);// power switch tail for controlling the lamp
DigitalOut relay_2(p22);// power switch tail for controlling the fan
DigitalIn P11(p11); // Digital inputs p10,p11,p12,p13,p14,p16,p17 for communication between two mbeds; p18 and p19 for handshake signals;
DigitalIn P12(p12);
DigitalIn P13(p13);
DigitalIn P14(p14);
DigitalIn P10(p10);
DigitalIn P16(p16);
DigitalIn P17(p17);
DigitalOut P18(p18);
DigitalIn P19(p19);
DigitalOut myled(LED1);
DigitalOut led2(LED2); // device 2
DigitalOut led3(LED3); //device 3
DigitalOut led4(LED4); //device 4
Serial pc(USBTX,USBRX);
float light_thresh=0.4; // set threshold value for light sensor
float ir_value=0.4; // set threshold value for IR sensor to detect the presence inside the house
int P111;
    int P112;
    int P113;
    int P114;
    int P115;
    int P116;
    int P117;
    Mutex bulb; //for locking and unlocking the lamp
    Mutex pc_lock; //for virtual COM port
        
    
void security_thread(void const *args) // thread for detecting presence near the house
{
    while(true)
    {
   
    wait(2);
    if(P116==1) // check if security feature is enabled or not
            {
                if(proxi_1==0) // check the status of proximity sensor
                {
                    bulb.lock();
                    led2=1;      //switch on device 2
                    relay_2=1;   //switch on the fan
                    bulb.unlock();
                    wait(3);
                    led2=0;       //switch off device 2
                    relay_2=0;     //switch off the fan
                    wait(3);
                   
                   
                    
                    }
                    
                    
                }
           
        
   } 
    
    
    }

int main() {
  
    P19.mode(PullUp);
     proxi_1.mode(PullUp);
     
    P18=1;     // Initialize the hand shake signal
    P116=0;     // Make sure the security feature is turned off by default
    Thread security(security_thread);
    
    while(1) {
        
       label: while(P19==1)   // wait till the mbed receives data from the master mbed
        {
            
            }
            
        if(P19==0)        //make sure if the read signal is a correct one by waiting for one second and checking again
        {       wait(1);
        if(P19!=0)
          goto label;
        }
        //store the status of the digital input pins 
        P111=(int)P11; // D1
        P112=(int)P12; // D2 
        P113=(int)P13; // D3 
        P114=(int)P14; // D4
        P115=(int)P10; // manual=0;automatic=1
        P116=(int)P16; //security on=1, off=0
        P117=(int)P17; //near=0, far=1

        pc_lock.lock();
        pc.printf("\n P11: %d, P12: %d, P13: %d, P14:%d, P15:%d, P16:%d, P17:%d\n Proxi_2 %f\n ",P111,P112,P113,P114,P115,P116,P117,(float)proxi_2);
               
        pc_lock.unlock();
        P18=0; //Indicate the reception of data by pulling p18 low
 
    // blink LED1 to indicate that data has been received
        myled = 1;
        wait(2);
        myled = 0;
        wait(2);
        P18=1;
       
        
        if((float)proxi_2<ir_value) // check presence inside house
        
        {
       
            if(P115==1) // check if automatic mode is turned on
            {
                if(P117==0) //check if the user is near the home location
                {
                    if((float)light_1<light_thresh) //check  value of light sensor, turn on light if it is less than the threshold
                    relay_1=1; 
                    else relay_1=0;                 //turn off light if there is enough ambient light 
                    pc.printf("Light sensor: %f \n",(float)light_1);
                    bulb.lock();
                    led2=1;            //turn on device2
                    relay_2=1;                 //turn on the fan
                    bulb.unlock();
                    led3=1;             //turn on device 3
                   led4=1;              //turn on device 4
                    
                    
                    }
                else                    //user is far away from home loation; turn off all devices 
                {
                    relay_1=0; 
                    bulb.lock();
                    led2=0;
                      relay_2=0;
                    bulb.unlock();
                    led3=0;
                   led4=0;
                    
                    
                    
                    }
                
                
                
                
                }
            else                //if the system is in manual mode
            {
                  relay_1=P111;     // read status of the lamp
                    bulb.lock();
                    led2=P112;             // read status of the device-2
                      relay_2=P112;       //read status of the fan
                    bulb.unlock();
                    led3=P113;           // read status of the device-3
                   led4=P114;            // read status of the device-4
                    
                    
                    }
        
    }
}
}
