/*
Copyright (c) 2011 Anthony Buckton (abuckton [at] blackink [dot} net {dot} au)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include <mbed.h>
#include <string>
#include <list>
#include "uLCD_4DGL.h"
#include <mpr121.h>

InterruptIn interrupt(p26);
InterruptIn interrupt1(p25);
uLCD_4DGL uLCD(p13,p14,p11); 
I2C i2c(p9, p10);
I2C i2c1(p28, p27);
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
Mpr121 mpr121_1(&i2c1, Mpr121::ADD_VSS);
PwmOut speaker(p21);
PwmOut speaker1(p22);
Serial pc(USBTX, USBRX);

int key_code=0;
int key_code1=0;
float beats = 0;
float beats_var = 0;
void pianoInterrupt() {
    
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;

    i=0;
 
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
        }
}

void drumsInterrupt() {
    
    int i=0;
    int value=mpr121_1.read(0x00);
    value +=mpr121_1.read(0x01)<<8;
     i=0;
    
    
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code1=i+1;
        }
  
}

void piano() {
      speaker.period(1.0/ (float (key_code*75.1) ) );
        speaker = float(key_code*2)/50.0;
        wait(.5);
}

void drums() {

          /*speaker1.period(1.0/ (float (key_code1*5.1) ) );
        speaker1 = float(key_code1*7)/ 30.0;*/
        wait(.5);
        
        switch(key_code1) {
        case 1:  
               beats = 1.0/ ( float (10.1) );
               speaker1.period( beats );
               speaker1.pulsewidth( beats );
        speaker1 = 0.009;
        break;
        case 2:  
        beats = 1.0/ ( float (15.1) );
        speaker1.period( beats );
         
        speaker1 = 0.9;
        break;
        case 3:    
        beats = 1.0/ ( float (20.1) );
        speaker1.period( beats );
        speaker1 = 0.9;
        break;
        case 4: 
        beats = 1.0/ ( float (25.1) );
        speaker1.period( beats );
        speaker1 = float(key_code1*2)/50.0;
        break;
        case 5:
        beats = 1.0/ ( float (30.1) );
           speaker1.period( beats );
           speaker1 = float(key_code1*2)/50.0;
        break;
        case 6: 
           beats = 1.0/ ( float (33.1) );
           speaker1.period( beats );
           speaker1 = float(key_code1*2)/50.0;
        break;
        case 7: 
        beats = 1.0/ ( float (40.1) );
        speaker1.period( beats );
        
           speaker1 = float(key_code1*2)/50.0;
        break;
        case 8: 
        beats = 1.0/ ( float (45.1) );
        speaker1.period( beats );
           speaker1 = 0.9;
        break;
        case 9: 
        beats = 1.0/ ( float (8.1) );
        speaker1.period( beats );
           speaker1 = float(key_code1*2)/50.0;
        break;
        case 10: 
        beats = 1.0/ ( float (5.1) );
        speaker1.period( beats );
        
           speaker1 = float(key_code1*2)/50.0;
        break;
        case 11: 
        beats = 1.0/ ( float (30.1) );
        speaker1.period( beats );
         speaker1.pulsewidth( 1.0/ ( float (10.1) ) );
         speaker1 = float(key_code1*2)/50.0;
        break;
        case 12:
        beats = 1.0/ ( float (10.1) );
        speaker1.period( beats );
                speaker1.pulsewidth( 0.9 );
        speaker1 = float(key_code1*2)/50.0;
        break;
        
        default:
        break;
        }
       
}
int d;
void LCD_Display() {
    uLCD.cls();
    uLCD.locate(0,0);
    
   
    
    
    uLCD.color(GREEN);
    uLCD.text_bold(ON);
    
    uLCD.printf("MUSIC ");
    uLCD.text_bold(ON);
    uLCD.printf("PLAYER" );
    uLCD.printf("\n\n" );
    
    uLCD.text_bold(OFF);
    uLCD.color(WHITE);
    uLCD.textbackground_color(BLUE);
    uLCD.printf("\nPiano\nKey Pressed %D", key_code );
    uLCD.color(GREEN);
    uLCD.textbackground_color(BLACK);
    uLCD.printf("\n\n" );
    uLCD.printf("Timbre: %0.2f", (float) speaker );
    uLCD.printf("\nPitch: %.2f", (float (key_code*75.1))  );
    uLCD.printf("\n" );
    uLCD.color(WHITE);
    uLCD.textbackground_color(BLUE);
    uLCD.printf("\nDrums\nKey Pressed %D", key_code1 );
    uLCD.color(GREEN);
    uLCD.textbackground_color(BLACK);
    uLCD.printf("\n\n" );
    uLCD.printf("Loudness: %0.2f", (float) speaker1 );
    beats_var = (beats == 0) ? 0 : (1.0 / (float)beats );
    d = (int) beats_var;
    uLCD.printf("\nBeats/Sec: %d", d  );
    uLCD.printf("\n" );
    uLCD.printf("\n\n" );
   
}

int main() {
  
   
  interrupt.fall(&pianoInterrupt);
  interrupt.mode(PullUp);
      interrupt1.fall(&drumsInterrupt);
    interrupt1.mode(PullUp);

    uLCD.background_color(BLACK);
    uLCD.cls();
    uLCD.color(WHITE);
        uLCD.textbackground_color(BLUE);
    uLCD.set_font(FONT_7X8);
    //uLCD.text_mode(OPAQUE);
    uLCD.text_mode(TRANSPARENT);
  while (1) {
       
      piano();
      drums();
      LCD_Display();
   }


}



