#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "QEI.h"

I2C i2c(PA_10,PA_9);
Adafruit_SH1106_I2c myOled(i2c,NC,0x78,64,128);

QEI EnB(D5,D6,NC,500,QEI::X4_ENCODING);//4倍编码器
//QEI EnB(PA_5,PA_6,NC,500);//2倍编码器
int main()
{
//i2c.frequency(100000);
    i2c.start();
    myOled.begin();
    myOled.display();
    wait(0.5);
    myOled.clearDisplay();
    //myOled.setTextColor(1);
    myOled.setTextSize(3);
    myOled.printf("Du long\r");
    int oldPosition  = -1;
    int newposition;
    while(1) {
        newposition = EnB.getPulses();
        if (oldPosition == -1) {
            myOled.setTextCursor(40,32);
            myOled.setTextSize(2);
            myOled.printf("ready!\r");
            myOled.display();
        }
        if (newposition < 0)
            newposition = -newposition;
        if (newposition > oldPosition) {
            myOled.clearDisplay();
            oldPosition = newposition;
            myOled.setTextCursor(40,32);
            myOled.setTextSize(3);
            myOled.printf("%d\r",oldPosition);
            myOled.display();
        }
    }
}