
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                  //
//                                      Fonctionnement du programme du DS1820                                       //
//                                                                                                                  //
//                                                                                                                  //
//  1)    Pour commencer le MBED initial le bus 1-Wire c'est-à-dire :                                               //
//          -    MBED envoi une impulsion à 0 pendant 480µs minimum                                                 //
//          -    Puis le DS1820 répond avec une impulsion à 0 de 60à 240µs.                                         //
//  2)    On utilise la fonction «Search ROM [F0]» qui va permettre au MBED de récupérer tous les numéros           //
//      de ROM des DS1820 et par la même occasion de savoir combien de DS1820 il y a sur le bus 1-Wire.             //
//  3)    On fait un reset du bus 1-Wire on envoi le numéro de ROM « 0x10,0x65,0xF2,0x45,0x2,0x8,0x0,0xAE »         //
//      pour communiquer avec le DS1820 désiré puis on utilise la fonction « Convert Temperature [44] »,            //
//      la valeur de la température est stocké dans le deuxième octet du scratchpad.                                //
//  4)    Puis on va lire dans le scratchpad la valeur de la température stockée dans la variable « temperature »   //
//      prise par le DS1820.                                                                                        //
//  5)    Affichage de la variable « temperature » sur un HyperTerminal grâce à une liaison série.                  //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////






#include "mbed.h"
#include "DS18S20.h"


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                               //
//                                        Affichage de la temperature                                            //
//                                                                                                               //  
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////


int main()                                                         /* debut du programme principal */ 
{
                                         
    float temperature;                                             /* declaration de la variabble
                                                                      flotante temperature */
    G__MOS_P =1 ;                                                   /* initialisation du P-MOS */
    FindDevices();                                                  /* fonction cherchant le nombre de ds1820 
                                                                       et leur numero de serie */
   
        
    while (true)                                                    /* boucle while infini */ 
    {

        if ( First() )                                              /* fonction if */
        {
         temperature =  DS1820_GetTemp();                           /* affectation du resultat de la temperature
                                                                       a la variable temperature */
         pc.printf("\t temp = % +.3g""\xb0""C   \r",temperature);   /* affichage de la temperature */                                                                    
        }
    }
}