#include "mbed.h"
#include "hcsr04.h"
#include "Adafruit_SSD1306.h"
/*#include "estadomovder.h"
#include "estadoinicio.h"
#include "estadocalentar.h"
#include "estadomovizq1.h"
#include "estadocentro.h"
#include "estadomovizq2.h"
#include "estadosoplado.h"*/


class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};

I2CPreInit gI2C(PB_9,PB_8);

Serial pc(USBTX, USBRX); // tx, rx
Serial bt(A5, A4); // tx, rx
Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);
Ticker repeticion;

DigitalOut led(LED1);
DigitalOut step(D13);
DigitalOut dir(D12);
DigitalOut enable(D11);
DigitalOut dirAMotor(D4);
PwmOut     dirBMotor(A3);
InterruptIn encoderA(A2);
DigitalOut rele(D3);
HCSR04  usensor(D7,D8);
DigitalIn final1(D9);
InterruptIn final2(D10);
AnalogIn Vout(A0);
AnalogIn Aout(A1);

enum estados {inicio,movder,calentar,movizq1,centro,movizq2,soplado};
estados estado;


void medir_corriente()
{

    float corriente=((Aout.read()*5)-2.5)/0.185;

    pc.printf("Intensidad medida = %.4f A \n", corriente);
    bt.printf("Intensidad medida = %.4f A \n", corriente);

}

int dato=0;

void estadoinicio()
{
    {
        if(bt.readable()) { //Mira si hay algun dato pendiente en el bt
            dato=bt.getc();  //Lee un caracter del bt

        }
        if (dato=='1') {            //Si el dato es un 1 comienza el proceso

            estado = movder;


        } else {      //Si el dato es cualquier otra cosa no empieza a hacer nada

            pc.printf("Reposo\n");
        }
    }
}


void estadomovderecha()
{
    if(final1==0) {
        enable=1; //activar el motor
        dir=1; //direccion hacia la derecha
        //step=1; // avanzar
        step=1;
        wait_us(100);
        step=0;
        wait_us(900);
        pc.printf("Estado: Moviendo derecha\n");
        gOled.printf("Transportando\n");
    } else {
        enable=0;
        estado=calentar;
        gOled.clearDisplay();
    }
}

void estadocalentar()
{
    float tension=Vout.read()*3.3;
    //pc.printf("Valor voltios %.4f leido flat\n",tension);

    float resistencia= ((3.3*100000.0)/tension)-100000.0;

    float temp= 3950.0/(log(resistencia/100000.0)+(3950.0/298.0));
    gOled.printf("Calentando a: %.4f\n",temp);

    if (temp<35.0) {
        //rele.write(1);
        rele=1;
        pc.printf("Estado: Rele activado\n");

    } else {
        rele=0;
        estado=movizq1;
        //gOled.clearDisplay();
    }
}

void estadomovizq1()
{
    unsigned int dist;
    usensor.start();
    dist=usensor.get_dist_cm();

    if(dist>20) {
        enable=1; //activar el motor
        dir=0; //direccion hacia la derecha
        step=1; // avanzar
        wait_us(100);
        step=0;
        wait_us(900);
        pc.printf("Estado: Moviendo izquierda1\n");
        gOled.printf("Transportando\n");
    } else {
        enable=0;
        estado=centro;
        gOled.clearDisplay();
    }
}


void estadocentro()
{
    {
        if(bt.readable()) { //Mira si hay algun dato pendiente en el bt
            dato=bt.getc();  //Lee un caracter del bt

        }
        if (dato=='2') {            //Si el dato es un 1 comienza el proceso

            estado = movder;
            gOled.printf("Pieza incorrecta\n");

        } else if(dato=='3') {      //Si el dato es una b enciende el led

            estado = movizq2;
            gOled.printf("Pieza correcta\n");
        }
    }
}

void estadomovizq2()
{
    if(final2==0) {
        enable=1; //activar el motor
        dir=1; //direccion hacia la derecha
        step=1; // avanzar
        wait_us(100);
        step=0;
        wait_us(900);
        pc.printf("Estado: Moviendo izquierda2\n");
        gOled.printf("Transportando\n");
    } else {
        enable=0;
        estado=soplado;
        gOled.clearDisplay();
    }
}

void estadosoplado()
{

    dirAMotor=0;
    pc.printf("Soplando pieza");
    gOled.printf("Soplando");
    wait(5);
    estado=inicio;

}



int main()
{
    pc.baud(115200);
    estado = inicio;
    gOled.begin();
    gOled.clearDisplay();

    repeticion.attach(&medir_corriente, 5.0); //Medir la intensidad cada tres segundos


    while(1) {
        switch (estado) {
            case inicio:
                estadoinicio();
                break;
            case movder:
                estadomovderecha();
                break;
            case calentar:
                estadocalentar();
                break;
            case movizq1:
                estadomovizq1();
                break;
            case centro:
                estadocentro();
                break;
            case movizq2:
                estadomovizq2();
                break;
            case soplado:
                estadosoplado();
                break;
            default:
                break;

        }
    }
}

