#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
//#include "SDFileSystem.h"
//#include "wave_player.h"
#include <mpr121.h>

// mutex to make the lcd lib thread safe
Mutex lcd_mutex;
//SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
PwmOut speaker(p26);
//wave_player waver(&speaker);
uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin
//Semaphore lcd_sem(1);

// Shiftbrite
DigitalOut latch(p15);
DigitalOut enable(p16);
SPI spi(p11, p12, p13);
/*
// Touchpad
// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p21);
// Setup the i2c bus on pins 9 and 10
I2C i2c(p9, p10);
// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
*/
// Test leds
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// sonar

DigitalOut trigger(p20);
//DigitalOut myled(LED1); //monitor trigger
//DigitalOut myled2(LED2); //monitor echo
DigitalIn echo(p19);
int distance = 0;
int correction = 0;
Timer sonar;


// global variables
int light = 0; // to keep track of lighting
int sound = 1; // to keep track of sound
int sb_freq = 1; // rgb frequency
int bright = 1; // time of the day

// Light sensor
AnalogIn photocell(p17);
//PwmOut myled(LED1);

// Microphone
class microphone
{
public :
    microphone(PinName pin);
    float read();
    operator float ();
private :
    AnalogIn _pin;
};

microphone::microphone (PinName pin):
    _pin(pin)
{
}

float microphone::read()
{
    return _pin.read();
}

inline microphone::operator float ()
{
    return _pin.read();
}


// joystick
class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();
//boolean functions to test each switch
    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();
//automatic read on RHS
    operator int ();
//index to any switch array style
    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;

};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
    wait(0.001); //delays just a bit for pullups to pull inputs high
}
inline bool Nav_Switch::up()
{
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}

//microphone mymicrophone(p19); // uncomment when using

// joystick
//Nav_Switch myNav(p25, p22, p23, p21, p24); //pin order on Sparkfun breakout

// Shiftbrite
void RGB_LED(int red, int green, int blue)
{
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}

// create threads
// first thread dealing with LCD
void LCD_thread1(void const *args)
{
    while(true) {       // thread loop
        lcd_mutex.lock();
        //lcd_sem.wait();
        //if (light == 0 && sound == 1) {
        if (light == 0) {
            // display red siren
            uLCD.filled_circle(SIZE_X/2, SIZE_Y/2, 10, RED);
            uLCD.filled_rectangle(SIZE_X/2 - 10, SIZE_Y/2, SIZE_X/2 + 10, SIZE_Y/2 + 30, RED);
            //}        else if (light == 1 || sound == 0) {
        } else if (light == 1) {
            // display white siren
            uLCD.filled_circle(SIZE_X/2, SIZE_Y/2, 10, WHITE);
            uLCD.filled_rectangle(SIZE_X/2 - 10, SIZE_Y/2, SIZE_X/2 + 10, SIZE_Y/2 + 30, WHITE);
            //}        else if (light == 2 && sound == 1) {
        } else if (light == 2) {
            // display  blue siren
            uLCD.filled_circle(SIZE_X/2, SIZE_Y/2, 10, BLUE);
            uLCD.filled_rectangle(SIZE_X/2 - 10, SIZE_Y/2, SIZE_X/2 + 10, SIZE_Y/2 + 30, BLUE);
        }
        lcd_mutex.unlock();
        //lcd_sem.release();
        Thread::wait(5); // wait till thread is done
    }
}

// second thread dealing with LCD
void LCD_thread2(void const *args)
{
    while(true) {       // thread loop
        lcd_mutex.lock();
        //lcd_sem.wait();
        if (sound == 1) {
            // some indication there is audio
            // text saying "!ALERT!"
            uLCD.color(0xFF0000);
            uLCD.locate(6,1);
            uLCD.set_font_size(7, 7);
            uLCD.printf("!ALERT !");
        } else if (sound == 0) {
            //uLCD.color(0x000000);
            uLCD.locate(6,1);
            uLCD.set_font_size(7, 7);
            uLCD.textbackground_color(BLACK);
            uLCD.printf("        ");
            // no indication
            // text removed
        }
        lcd_mutex.unlock();
        //lcd_sem.release();
        Thread::wait(5); // wait till thread is done
    }
}

// thread playing video
void video_thread(void const *args)
{
    uLCD.media_init();
    uLCD.set_sector_address(0x001D, 0x4C42);
    uLCD.display_video(0,0);
}

int play = 1;

// thread dealing with speaker
void speaker_thread(void const *args)
{
    // play siren
    while(true) {         // thread loop
        /*FILE * wave_file;
        wave_file = fopen("/sd/police-siren.wav","r");
        if (play == 1) {
        sound = 1; // comment when using mic
        waver.play(wave_file);
        //play = 0; // comment when using joystick or touchpad
        } else if (play == 0) {
        // how can we stop play midway? - reduce volume?
        sound = 0; // comment when using mic
        wait(5); // comment when using joystick or touchpad
        play = 1; // comment when using joystick or touchpad
        }
        fclose(wave_file);*/
        //if (play == 1) {
        for (int i=0; i<1000; i=i+2) {
            speaker.period(1.0/969.0);
            speaker = float(i/50.0);
            wait(.5);
            speaker.period(1.0/800.0);
            wait(.5);
            sound = 1;
            if (play == 0) {
                sound = 0;
                //wait(1);
                break;
            }
            //  }
        }
        ///wait(1);
        Thread::wait(1000);    // wait 1s
    }
}

// thread reading from - ultrasonic sensor to do XYZ
void sonar_thread(void const *args)
{
    sonar.reset();
    sonar.start();
    while(echo==2) {}

    //while (echo==2) {};
    //led2 = 0;
// stop timer
    sonar.stop();
// read timer
    correction = sonar.read_us();
//    printf("Approximate software overhead timer delay is %d uS\n\r",correction);

//Loop to read Sonar distance values, scale, and print
    while(1) {
// trigger sonar to send a ping
        trigger = 1;
        //led1 = 1;
        //led2 = 0;
        sonar.reset();
        wait_us(10.0);
        trigger = 0;
        //led1 = 0;
//wait for echo high
        while (echo==0) {};
        //led2=echo;
//echo high, so start timer
        sonar.start();
//wait for echo low
        while (echo==1) {};
//stop timer and read value
        sonar.stop();
//subtract software overhead timer delay and scale to cm
        distance = (sonar.read_us()-correction)/58.0;
        //led2 = 0;
//        printf(" %d cm \n\r",distance);
//wait so that any echo(s) return before sending another ping
        //wait(0.2);
        if (distance < 10) {
            play = 0;
        } else {
            play = 1;
        }
        Thread::wait(500);
    }
}


// thread reading from - tactile switch to control RGB/sound/lcd
/*
void switchthread(void const *args)
{
    while(true) {
        // control sound & RGB frequency
        //with pullups a button hit is a "0" - "~" inverts data to leds
        //mbedleds = ~(myNav & 0x0F); //update leds with nav switch direction inputs FOR TESTING ONLY
        if (myNav.up()) play = 1;
        if (myNav.down()) play = 0;
        if (sb_freq > 0.5) {
            if (myNav.left()) sb_freq -= 0.2;
        }
        if (sb_freq < 3) {
            if (myNav.right()) sb_freq += 0.2;
        }
        //if(myNav.fire()) mbedleds = 0x0F; //special all leds on case for fire (center button)
        //or use - if(myNav[4]==0) mbedleds = 0x0F; //can index a switch bit like this
        Thread::wait(200);
    }
}*/
/*
// thread reading from - touch keypad same
void touchpad_thread(void const *args)
{
    while(true) {         // thread loop
        int key_code = 0;
        int i=0;
        int value=mpr121.read(0x00);
        value +=mpr121.read(0x01)<<8;
        // LED demo mod
        i=0;
        // puts key number out to LEDs for demo
        for (i=0; i<12; i++) {
            if (((value>>i)&0x01)==1) key_code=i;
        }
        if (key_code == 6) {
            play = 1;
        } else if (key_code == 4) {
            play = 0;
        } else if (key_code == 1) {
            if (sb_freq > 0.5) {
                sb_freq += -0.2;
            }
        } else if (key_code == 9) {
            if (sb_freq < 3) {
                sb_freq += 0.2;
            }
        }
    }
}
*/
// thread reading from - light sensor to do something

void lightsensor_thread(void const *args)
{
    while(true) {         // thread loop
        if (photocell*3.3 < 1.34) {
            bright = 0;
        } else {
            bright = 1;
        }
        //wait(0.1);
        Thread::wait(500);    // wait 0.25s
    }
}

//int mymic;
/*
// thread reading from - microphone to control rgb
void mic_thread(void const *args)
{
    while(true) {         // thread loop
        //read in, subtract 0.67 DC bias, take absolute value, and scale up .1Vpp to 15 for builtin LED display
        mymic = int(abs((mymicrophone - (0.67/3.3)))*500.0);
        //Use an 8kHz audio sample rate (phone quality audio);
        if (mymic > 0.5) {
            sound = 1;
            //wait(7); // song is around 8 seconds long
        } else {
            sound = 0;
        }
        //wait(1.0/8000.0);
        Thread::wait(1000);    // wait 0.25s
    }
}
*/
int main()
{
    uLCD.cls();
    wait(1);

    // shiftbrite stuff
    int red=0;
    int green=0;
    int blue=0;
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    wait(2);

    // t5 and t6 should not run at the same time

    // call threads here
    Thread t1(LCD_thread1); //start thread1
    Thread t2(LCD_thread2); //start thread2
    Thread t3(speaker_thread); //start thread3
    //Thread t4(sonar_thread); // start thread4
    //Thread t5(switchthread); //start thread5
    //Thread t6(touchpad_thread); //start thread6
    Thread t7(lightsensor_thread); //start thread7
    //Thread t8(mic_thread); //start thread8

    //t1.set_priority(osPriorityHigh);
    //t2.set_priority(osPriorityHigh);
    //t3.set_priority(osPriorityNormal);
    //t5.set_priority(osPriorityHigh);
    //t1.yield();
    //t2.yield();
    //t3.yield();
    //t5.yield();

    // running shiftbrite
    int color = 255;

    while(1) {

         if (bright == 0) {
             color = 150;
             green = 100;
         } else if (bright == 1) {
             color = 255;
             green = 0;
         }

        if (sound == 0) {
            RGB_LED(0,0,0);
            Thread::wait(200);
        } else {
            light = 0;
            red = color;     // flash red light
            //green = 0;
            blue = 0;
            RGB_LED(red, green, blue);
            wait(sb_freq);
            //wait(0.5);

            RGB_LED(0,0,0);
            wait(sb_freq);
            //wait(0.5);

            light = 1;
            red = color;     // flash white light
            //green = color;
            blue = color;
            RGB_LED( red, green, blue);
            wait(sb_freq);
            //wait(0.5);

            RGB_LED(0,0,0);
            wait(sb_freq);
            //wait(0.5);

            light = 2;
            red = 0;     // flash blue light
            //green = 0;
            blue = color;
            RGB_LED( red, green, blue);
            wait(sb_freq);
            //wait(0.5);

            RGB_LED(0,0,0);
            wait(sb_freq);
            //wait(0.5);

            light = 1;
            red = color;     // flash white light
            //green = color;
            blue = color;
            RGB_LED( red, green, blue);
            wait(sb_freq);
            //wait(0.5);

            RGB_LED(0,0,0);
            wait(sb_freq);
            //wait(0.5);
            Thread::wait(500);
        }
    }
}
