
#include "mbed.h"
#include "EthernetInterface.h"
#include "ID12RFID.h"

ID12RFID rfid(p14); // uart rx
EthernetInterface eth;
//Here is the IP address of Server and port
const char* ECHO_SERVER_ADDRESS = "130.207.234.205";
const int ECHO_SERVER_PORT = 7;

int main() {
    printf("Hello World\n");
    eth.init(); //Use DHCP
    //print out the MAC address first
    printf("MAC Address is %s\n", eth.getMACAddress());
    
    while(1) {
        if(rfid.readable()) {
            int j=rfid.read();
            //check if using right tag
            if (j==36902518){
                printf("Right RFID, Here is the Monitor Info\r\n");
                eth.connect(7000);//Longer timeout here
                printf("Client IP Address is %s\n", eth.getIPAddress());
                TCPSocketConnection socket;
                //Begin Connecting the server, if not, print the error info
                while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) {
                    printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
                    wait(1);
                }
                //Begin receiving the data from server, and print out onto the terminal 
                char buf[256]={0};
                int n = socket.receive(buf, 256);
                buf[n] = '\0';
                printf("%s", buf);
                socket.close();
                eth.disconnect();        
            }
            //if not right tag, print out the error info and wait for another tag
            else
                printf("Wrong RFID Tag\r\n");
           
            printf("Wait for next RFID Tag\r\n");     
        }
    }
}
