/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "Map.hpp"

Serial pc(USBTX, USBRX);
Serial bt(PA_9, PA_10);
PwmOut ledPWM(PA_1);
AnalogIn flexSensor(PA_7);
Map map(0.8, 1.0, 0, 4);

int main() {
    int analogValueLevel;
    
    pc.baud(115200);
    bt.baud(115200);
    ledPWM.period(0.01f);
    ledPWM = 0.0f;
    
    pc.printf("Hello World! HC-06 bluetooth example...\n\r");
    
    while (true) {        
        analogValueLevel = (int)map.Calculate(flexSensor);
        
        bt.printf("%d\n", analogValueLevel);
        
         ledPWM = 0.25f * analogValueLevel;
        
        wait(0.5f);
    }
}
