#ifndef HEADER_whatever
#define HEADER_whatever

#include "mbed.h"
#include "rtos.h"
#include "WattBob_TextLCD.h"

#include "MCP23017.h"

#define     pin_analog_1    p15
#define     pin_analog_2    p16

#define     pin_digital_1   p17
#define     pin_digital_2   p18
#define     pin_digital_3   p19
#define     pin_digital_4   p20

#define     pin_LED1        LED1
#define     pin_LED2        LED2
#define     pin_LED3        LED3
#define     pin_LED4        LED4
#define     pin_LED5        p25
#define     pin_LED6        p26


#define     MAXSPEED        100
#define     SAMPLESIZE      5 
#define     SPEEDLIMIT      88

//FREQUENCIES
#define     CLOCKFREQ       20
#define     TASKFREQ1       8   
#define     TASKFREQ2       10   
#define     TASKFREQ3       4   
#define     TASKFREQ4       4   
#define     TASKFREQ5       4   
#define     TASKFREQ6       5   
#define     TASKFREQ7       2   
#define     TASKFREQ8       4   
#define     TASKFREQ9       1
#define     TASKFREQ9S2     2   
#define     TASKFREQX       0.5   




//call the functions at the end for the main 


//STRUCTURE 
typedef struct
{
    float brakevalue;
    float accelvalue;
    float array[5];
    float average;
    float rawspeed;
}SDATA;






typedef struct
{
    int         ENGINESTATE;
    float       odometer;
    float     leftind;
    float     rightind;
    float     sideind;
}CARINFO;



typedef struct
{
    float brakevalue;
    float accelvalue;
    float odometer;
    float rawspeed;
    
}SIMU_DATA;




//calling all functions 

void task1readbrake();
void task2readaccel();
void task3enginestate();
void task4average();
void task5brakeLED();
void task6speedmonitor();
void task7displayvalues();
void task8sidelights();
void task9indLED();
void taskXserialdump();


#endif