#include "header.h"


//definitions of tasks
//lock and unlock variables in struct when performing calculations 

//pedals 
AnalogIn            brake_pedal(pin_analog_1);
AnalogIn            accel_pedal(pin_analog_2);


//switches
DigitalIn           ngene(pin_digital_1);
DigitalIn           leftsw(pin_digital_2);
DigitalIn           rightsw(pin_digital_3);
DigitalIn           sidesw(pin_digital_4);


//indicators 
DigitalOut          ngeneind(pin_LED1);
DigitalOut          leftind(pin_LED2); //was digitalout
DigitalOut         rightind(pin_LED3);//was digitalout
DigitalOut          sideind(pin_LED4);


//RED box lights
DigitalOut          brakeind(pin_LED5);
DigitalOut          overspeedind(pin_LED6);



//
extern SDATA speed;
extern CARINFO info;
extern SIMU_DATA sim;

// LCD

extern WattBob_TextLCD *display;

// MUTEX

extern Mutex simuXS;
extern Mutex speedXS;
extern Mutex carstateXS;
//

//serial port 
Serial PC(USBTX, USBRX);

void task1readbrake()
{  
   float delay = 1000 / TASKFREQ1;
   while(true){
       
   speedXS.lock();//lock
   
   speed.brakevalue = brake_pedal.read(); 
   
   speedXS.unlock();//unlock
   
   Thread::wait( (int) delay);
   
   }
}

void task2readaccel()
{
   float delay = 1000 / TASKFREQ2;
   while(true){
       
   speedXS.lock();//lock
   
   speed.accelvalue = accel_pedal.read(); 
   
   speedXS.unlock();//unlock
   
   Thread::wait( (int) delay);
   
   }
   
}

void task3enginestate()
{
    float delay = 125;      
    while(true){
    //lock
    carstateXS.lock();
    uint8_t engineonoff = ngene.read();  
    info.ENGINESTATE = engineonoff;
    carstateXS.unlock();
    //unlock
    
    if(engineonoff == 1){
        ngeneind = 1;
        }
    else{
        ngeneind = 0;
        }
        
    Thread::wait(125);
    }             
}

void task4average()
{
    float delay = 1000 / TASKFREQ4;    
    while(true){
    speedXS.lock();//lock
    
    for(int i = 0; i < SAMPLESIZE - 1 ; i++){
        //speed.rawspeed = (speed.accelvalue - speed.brakevalue)*MAXSPEED;
        speed.average += speed.array[i];
        }
        speed.average = (speed.average / SAMPLESIZE);    
               
    speedXS.unlock();//unlock 
    
    Thread::wait( (int) delay);
    }
}

void task5brakeLED()
{
    float delay = 1000 / TASKFREQ5;
    while(true){
        
        //lock
        speedXS.lock();
        float braketest = speed.brakevalue;     
        
        speedXS.unlock();//unlock
        
        if( braketest > 0.2) // speed increase
            brakeind = 1;
        else
            brakeind = 0;
    
    Thread::wait((int)delay);
        }
}


void task6speedmonitor()
{
    float delay = 1000 / TASKFREQ6;
    while(true){
        
        carstateXS.lock();  //lock carstate
        speedXS.lock();     //lock speed
        
        
        info.odometer += (speed.rawspeed / TASKFREQ6);
        uint8_t temp_enginestate = info.ENGINESTATE;
        
        carstateXS.unlock(); //unlock carstate
        
        float temp_accel = 0.0;
        if(temp_enginestate != 0)
            temp_accel = speed.accelvalue;
        
        //update speed    
        speed.rawspeed += (temp_accel - speed.brakevalue) * MAXSPEED; 
        
        if(speed.rawspeed < 0)
            speed.rawspeed = 0;
        if(speed.rawspeed > MAXSPEED)
            speed.rawspeed = MAXSPEED;   
        
        // Saving the new speed
        for (int i = 0; i < SAMPLESIZE - 1; i++)
            speed.array[i]= speed.array[i+1]; 
            speed.array[4]= speed.rawspeed;
            
        float temp = speed.rawspeed;
        
        // UNLOCK Speed
        speedXS.unlock();
        
        // Update Overspeed display
        
        if (temp > 39.3395) //88 mph to ms
            overspeedind = 1;
        else
            overspeedind = 0;
            
        Thread::wait((int)delay);
        }
}

void task7displayvalues()
{
    float delay = 1000 / TASKFREQ7;
    display->cls();
    while(true){
        
        
    
        //LOCK data
        carstateXS.lock();
        //LOCK Speed
        speedXS.lock();
        
        display->locate(1,0);
        display->printf("AvgS: %.2f m/s",speed.average);
        display->locate(0,0);
        display->printf("ODOM: %d m",(int) info.odometer);
     
        //UNLOCK data
        carstateXS.unlock();
        //UNLOCK Speed
        speedXS.unlock();
        


        
        Thread::wait(500);
        
        
        }
}

void task8sidelights()
{
    float delay = 1000 / TASKFREQ8;
    while(true){
               
        // LOCK Car data
        carstateXS.lock();
        
        info.sideind = sidesw.read();
        uint8_t temp = info.sideind;
        
        //UNLOCK Car data
        carstateXS.unlock();
        
        if (temp == 1)
            sideind = 1;
        else
            sideind = 0;
        
        Thread::wait((int)delay);
        
        
        
        
        }
}

void task9indLED()
{
    int count = 0;
    while(true){
        
       

       count++;
       leftind = leftsw;
       rightind = rightsw;
       (leftsw==1)?         info.leftind = 1:   info.leftind = 0;
       (rightsw==1)?        info.rightind = 1:   info.rightind = 0;
       
       if (leftsw == 1 && rightsw == 1){
        carstateXS.lock();
        leftind = 0;
        rightind = 0; // current issue :just stopping here 
        carstateXS.unlock();
        }
        if (count == 2||count == 4){ // flash indicators every second
                    carstateXS.lock();
               if (leftind == 1 && rightind == 0){
                leftind = 0;
                    }
        else if (rightind == 1 && leftind == 0){
                rightind = 0;
                    }
        
        else if (leftind == 0 && rightind == 0){
                    }
                    carstateXS.unlock();
        }
        if (count == 4){ // send data every 2 seconds
            count = 0;
        }
        Thread::wait(500);
        
        }

}


void taskXserialdump()
{
    while(true)
    {
    speedXS.lock();
    
    PC.printf("SPEED: %.1f\r\n",speed.rawspeed);
    PC.printf("BRAKE: %.2f\r\n",speed.brakevalue);
    PC.printf("ACCELEROMETER: %.2f\r\n",speed.accelvalue);
    
    speedXS.unlock();
    
    carstateXS.lock();  
    
    PC.printf("LEFT INDICATOR  : %.1f\r\n",info.leftind);
    PC.printf("RIGHT INDICATOR : %.1f\r\n",info.rightind);
    
    carstateXS.unlock();
    
    float delay = 1000/ TASKFREQX;
    Thread:: wait((int)delay);
      
    }



} 