
#ifndef SMARTGPU_H
#define SMARTGPU_H

#include <mbed.h>

//****USER DEFINED PINS (modify to select another serial port of MBED*****//
// Definitions of Pin out for MBED
//#define TXpin    p13
//#define RXpin    p14
//#define resetPin p15
//**********************END OF USER DEFINED PINS**************************//


//******************LIBRARY DEFINED PINS (don't modify)*******************//
//General definitions
#define RESET 13
#define TX 1
#define RX 0
#define OFF 0
#define ON 1
#define FULL 127
#define UNFILL 0
#define FILL 1
#define TRANS 0
#define COLOUR 1
#define BEGINNING 0
#define ALLCONTENTS 0
#define LANDSCAPEL  0x00  //left
#define PORTRAITL   0x01  //low
#define LANDSCAPER  0x02  //right
#define PORTRAITT   0x03  //top
#define DOUT0 0
#define DOUT1 1
#define GND 0
#define VCC 1
#define XCOORD 0
#define YCOORD 1
#define WIDTH  320
#define HEIGHT 240

//basic colours definition
#define BLACK   0x0000
#define WHITE   0xFFFF
#define RED     0xF800
#define GREEN   0x07E0
#define BLUE    0x001F
#define YELLOW  0xFFE0
#define CYAN    0x07FF
#define MAGENTA 0xF81F

//fonts definition
#define FONT0   0x00
#define FONT1   0x01
#define FONT2   0x02
#define FONT3   0x03
#define FONT4   0x04
#define FONT5   0x05
#define FONT6   0x06
#define FONT7   0x07

//**************************************************************************
// class SMARTGPU SMARTGPU.h
// This is the main class. It shoud be used like this : SMARTGPU lcd(p13,p14,p15);

class SMARTGPU{
    
public:
    
    SMARTGPU(PinName TXPin, PinName RXPin, PinName resetPin);
    
    void init();

    void reset();
    
    unsigned char start();  

    unsigned char erase();

    unsigned char sleep(unsigned char);
    
    unsigned char orientation(unsigned char);
    
    unsigned char bright(unsigned char);
    
    unsigned char baudChange(unsigned long val);
    
    unsigned char digitalOut(unsigned char, unsigned char);
    
    unsigned char setScreenBackground(int);
    
    unsigned char setTextBackground(int);
    
    unsigned char memoryRead(int, int, int, int, char[]);
    
    unsigned char putPixel(int, int, int);
    
    unsigned char drawLine(int, int, int, int, int);
    
    unsigned char drawRectangle(int, int, int, int, int, unsigned char);
    
    unsigned char drawTriangle(int, int, int, int, int, int, int, unsigned char);
    
    unsigned char drawCircle(int, int, int, int, unsigned char);
    
    unsigned char putLetter(int, int, int, unsigned char, unsigned char, unsigned char);
    
    unsigned char string(int, int, int, int, int, unsigned char, unsigned char, char[]);
    
    unsigned char stringSD(int, int, int, int, int, unsigned char, unsigned char, int, int, char[]);
    
    unsigned char icon(int, int, int, int, char[]);
    
    unsigned char imageSD(int , int , char[]);
    
    unsigned char touchScreen(int[]);
    
    unsigned char touchIcon(char[]);

    protected :

    Serial     _serialSMARTGPU;
    DigitalOut _resetPin;
    
};
typedef unsigned char BYTE;

#endif
