#include "mbed.h"
#include "JPEGCamera.h"
Serial pc(SERIAL_TX,SERIAL_RX,38400);

int main() {
    JPEGCamera camera(D1, D0); // TX, RX
   // LocalFileSystem local("local");
    Timer timer;
    timer.start();
    camera.setPictureSize(JPEGCamera::SIZE320x240);

    for (int i = 0; i < 10; i++) {
        if (camera.isReady()) {
            char filename[25];
            sprintf(filename, "/local/pict%03d.jpg", i);
            printf("Picture: %s ", filename);
            if (camera.takePicture(filename)) {
                while (camera.isProcessing()) {
                    camera.processPicture();
                }
            } else {
                printf("take picture failed\n");
            }
        } else {
            printf("camera is not ready\n");
        }
    }
    printf("time = %f\n", timer.read());
}