#include "mbed.h"
#include "ble/BLE.h"

Serial pc(USBTX, USBRX);

#define LED_RED     p22
#define LED_GREEN   p21
#define LED_BLUE    p23
#define BUTTON_PIN  p17
#define BATTERY_PIN p1

DigitalOut greenLed(LED_GREEN);

struct Packet {
    uint8_t seqNum;
    
    Packet() : seqNum(0) {}
};
uint8_t seqNum2 = 7;

BLE ble;
Packet packet;
const static char DEVICE_NAME[] = "Transmitter";
static volatile bool  triggerSensorPolling = false;

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    ble.gap().startAdvertising(); // restart advertising
}

void periodicCallback(void)
{
    greenLed = !greenLed; /* Do blinky on greenLed while we're waiting for BLE events */
    //we can't do anything related gap() inside here!
    //will get error and fault handler will be triggered
    
    /* Note that the periodicCallback() executes in interrupt context, so it is safer to do
     * heavy-weight sensor polling from the main thread. */
    triggerSensorPolling = true;
}

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &localBle          = params->ble;
    ble_error_t error = params->error;
    
    if (error != BLE_ERROR_NONE) {
        return;
    }
    
    /* Ensure that it is the default instance of BLE */
    if (localBle.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;   
    }
    
    localBle.gap().onDisconnection(disconnectionCallback);

//    localBle.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
//    localBle.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
//    localBle.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, (uint8_t *)&packet, sizeof(packet));
    localBle.gap().clearAdvertisingPayload();
    localBle.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, (uint8_t *)&packet.seqNum, sizeof(packet.seqNum));
    pc.printf("73: payload: %x\n", localBle.gap().getAdvertisingPayload());
}

int main(void)
{
    greenLed = 1;
    
    Ticker ticker;
    ticker.attach(periodicCallback, 5);
    
    ble.init(bleInitComplete);
    
    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (ble.hasInitialized()  == false) {
         pc.printf("Initializing BLE\n");
    }
    
    pc.printf("Init Completed\n");
    
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms */
    ble.gap().setAdvertisingTimeout(0);
    ble.gap().startAdvertising();
    
    while (1) {
        // check for trigger from periodicCallback()
        if (triggerSensorPolling) {
            (packet.seqNum)++;
            pc.printf("seq_num: %d\n", packet.seqNum);
            ble.gap().clearAdvertisingPayload();
            ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, (uint8_t *)&packet.seqNum, sizeof(packet.seqNum));
            pc.printf("47: payload: %x\n", ble.gap().getAdvertisingPayload());
            
            triggerSensorPolling = false;
        } 
        ble.waitForEvent();
    }
}