#include "mbed.h"
#include "ble/BLE.h"
#include <time.h>

#define LED_RED     p21
#define LED_GREEN   p22
#define LED_BLUE    p23
#define BUTTON_PIN  p17
#define BATTERY_PIN p1

#define NUM_UNIQUE_PACKETS 5

Serial pc(USBTX, USBRX);

DigitalOut redLed(LED_RED);
DigitalOut blueLed(LED_BLUE);

const uint8_t TRANSMITTER_MAC_ADDRESS = 0xF34F887FED4E;
//const static char DEVICE_NAME[] = "Receiver";
volatile bool received[NUM_UNIQUE_PACKETS];

struct Data {
  uint32_t seqNum;
};

// void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)

void scanCallback(const Gap::AdvertisementCallbackParams_t *params)
{
    static int numMeas;
    static double avgMeas;
    
    static clock_t clock1, clock2;
    
    if (*(params->peerAddr) == (uint8_t) TRANSMITTER_MAC_ADDRESS) {
        
        // BREDR_NOT_SUPPORTED                = 0x04
        // LE_GENERAL_DISCOVERABLE            = 0x02
        // COMPLETE_LOCAL_NAME                = 0x09
        // MANUFACTURER_SPECIFIC_DATA         = 0xFF
        
        // Data received: 02 ff (MANUFACTURER_SPECIFIC_DATA) 0  (Sequence Number)
        
        // Turn off the blue led
        blueLed = 1;
        
        const uint8_t * data = params->advertisingData;
        
        int seqNum = (int)data[2];
        received[seqNum] = true;
        // pc.printf("Received packet with seq num: %d\n", seqNum);
        
        bool done = true;
        for(int i=0; i<NUM_UNIQUE_PACKETS; i++) {
            done = done && received[i];
        }
        
        if(done == true) {
            // Set the blue LED
            blueLed = 0;
            
            clock2 = clock1;
            clock1 = clock();
            
            // Print the time
            if (clock2 != 0) {
                double timeUsed = ((double) (clock1 - clock2)) / CLOCKS_PER_SEC;
                printf("Time to get full set: %f\n", timeUsed);
                
                avgMeas = ((float)numMeas * avgMeas + timeUsed) / (numMeas + 1);
                numMeas++;
                pc.printf("Average time: %f seconds\n", avgMeas);
           }
            
            // Reset the bool array
            for (int i=0; i<NUM_UNIQUE_PACKETS; i++) {
                received[i] = false;   
            }            
        }
    }
    return;
}


void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &localBle          = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        return;
    }
    
    redLed = 1;
    blueLed = 1;
    
    /* Set up scanning prodedure */
    localBle.gap().setScanParams(GapScanningParams::SCAN_INTERVAL_MAX, GapScanningParams::SCAN_WINDOW_MAX, 0, false);
    localBle.gap().startScan(scanCallback);
    
    for(int i=0; i<NUM_UNIQUE_PACKETS; i++) {
        received[i] = false;
    }
        
    pc.printf("Init Completed\n");
}


int main(void)
{
    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
    ble.init(bleInitComplete);
    
    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (ble.hasInitialized() == false) {
        pc.printf("Intiailizing BLE\n");
    }
    
    pc.printf("We are done initializing\n");
    
    while (1) {
        ble.waitForEvent(); // low power wait for event
    }
}
