#include "ClockControl.h"

void setPLL0Frequency(unsigned char clkSrc, unsigned short M, unsigned char N)
{
      LPC_SC->CLKSRCSEL = clkSrc;
      LPC_SC->PLL0CFG   = (((unsigned int)N-1) << 16) | M-1;
      LPC_SC->PLL0CON   = 0x01;             
      LPC_SC->PLL0FEED  = 0xAA;
      LPC_SC->PLL0FEED  = 0x55;
      while (!(LPC_SC->PLL0STAT & (1<<26)));
    
      LPC_SC->PLL0CON   = 0x03;
      LPC_SC->PLL0FEED  = 0xAA;
      LPC_SC->PLL0FEED  = 0x55;
}

void setPLL1Frequency(unsigned short M, unsigned char P)
{
      LPC_SC->PLL1CFG   = (((unsigned int)P-1) << 16) | M-1;
      LPC_SC->PLL1CON   = 0x01;             
      LPC_SC->PLL1FEED  = 0xAA;
      LPC_SC->PLL1FEED  = 0x55;
      while (!(LPC_SC->PLL1STAT & (1<<10)));
    
      LPC_SC->PLL1CON   = 0x03;
      LPC_SC->PLL1FEED  = 0xAA;
      LPC_SC->PLL1FEED  = 0x55;
}

unsigned int setSystemFrequency( unsigned char USBclkDivider, unsigned char clkDivider, unsigned char clkSrc, unsigned short M, unsigned char N)
{
    setPLL0Frequency(clkSrc, M, N);
    LPC_SC->CCLKCFG = clkDivider - 1;
    LPC_SC->USBCLKCFG = USBclkDivider - 1;
    // Default "PCLK_peripheral = CCLK/4". 
    // If System Clock is changed from default, TIMER3 changes with it. eg 96Mhz System clock TIMER3 1uS = 1uS. System Clock = 120Mhz. 1uS will actually become 0.8uS.
    //LPC_SC->PCLKSEL1 = 1 << 14; // Sets divider for TIMER3 to CCLK / 1.
    //LPC_TIM3->PR = 74;    // Sets prescaler for TIMER3 counter. (Default at 96Mhz and PCLKSEL = 0 (ie. CCLK/4) is 23) Therefore if we set PCLKSEL = CCLK/1 and scale down by (23*4) * 96Mhz/120hz = 73.6. Not perfect...but it works 
    SystemCoreClockUpdate();
    return SystemCoreClock;
}

void setPPL1forUSB(unsigned short M, unsigned char P) 
{
   setPLL1Frequency(M, P);    // Drive USB subsystem from PLL1 
}