// RFID Tweeter
/*
  Update: 21-06-2010
  The basic authentication service for twitter is going down.
  To continue using that program, the code has been updated to use http://supertweet.net which acts as an API proxy.
  Simply visit the website to setup your twitter account for this API.
  See: http://www.supertweet.net/about/documentation
*/

#include "mbed.h"
//#include "ID12RFID.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

#define TWITTER_USER "cilabnerds"
#define TWITTER_PASSWORD "********"

#define IDS_COUNT 3
//const int ids_list[IDS_COUNT] = {89481809, 89481810, 89481811};
//const char* names_list[IDS_COUNT] = {"Donatien", "Simon", "Dan"};

EthernetNetIf ethernet;
HTTPClient twitter;

//ID12RFID rfid(p14);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int main() {
    led1 = 1;
    if (ethernet.setup() == ETH_OK)
        led2 = 1;
    else{
        led1 = 0;
    }
    wait(2);
    
    twitter.basicAuth(TWITTER_USER, TWITTER_PASSWORD);
    led3 = 1;
    
    HTTPMap msg;
    msg["status"] = "Alvaro esta twitteando desde una plaquita mbed NXP LPC1768. Experimentos desde \@cilabtwitt.";
    HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL);
    
    if(r == HTTP_OK)
        led4 = 1;
    else{
        led1 = 0;
        led2 = 0;
        led3 = 0;
   }
}
