#include "mbed.h"
#include "DS1302.h"

DigitalOut sclk(PG_12);//CLK
DigitalInOut io(PG_9);//DAT
DigitalOut ce(PE_1);//RST

uint8_t tim[7]={0x30, 0x00, 0x23, 0x20, 0x07, 0x01, 0x20};//秒分时日月周年
uint8_t w[7]={0x80, 0x82, 0x84, 0x86, 0x88, 0x8a, 0x8c};  //写地址
uint8_t r[7]={0x81, 0x83, 0x85, 0x87, 0x89, 0x8b, 0x8d};  //读地址
uint8_t miao,fen,shi,zhou,ri,yue,nian;

void ds1302writebyte(uint8_t dat)   //单字节写
{
    uint8_t i,value;
    sclk = 0;
    wait_us(20);                                             
    
    io.output();        
    for(i=0;i<8;i++)
    {
        value=dat&0x01; 
        if(value)
            io = 1;
        else
            io = 0;
        dat>>=1;
        sclk = 1;
        wait_us(20);
        sclk = 0;
        wait_us(20);    
    }
}

void ds1302writebytes(uint8_t add, uint8_t dat) //多字节写
{
    ce = 0;
    wait_us(20);
    ce = 1;
    wait_us(20);
    ds1302writebyte(add);
    ds1302writebyte(dat);
    ce = 0;
    wait_us(20);            
}

uint8_t cmd_readbyte(uint8_t add){  //读指令
    uint8_t i, value;
    ce = 0;
    wait_us(20);
    ce = 1;
    wait_us(20);
    
    sclk = 0;
    wait_us(20); 

    //写入1字节地址
    io.output();        
    for(i=0;i<8;i++){
        value=add&0x01; 
        if(value)
            io = 1;
        else
            io = 0;
        add>>=1;
        sclk = 1;
        wait_us(20);
        if(i<7){
            sclk = 0;
            wait_us(20);
        }
    }

    //读取1字节
    io.mode(PullUp);
    io.input();
    value = 0;
    wait_us(20);
    for(i=0; i<8; i++){
        sclk = 0;
        //wait_us(20);

        value>>=1;
        if(io.read() == 1)
            value|=0x80;
        sclk = 1;
        wait_us(20);
    }

    ce = 0;
    wait_us(20);
    sclk = 0;
    wait_us(20);

    return value;
}

void settime()
{
    uint8_t i;
    ds1302writebytes(0x8e,0x00);
    for(i=0;i<7;i++)
    {
        ds1302writebytes(w[i],tim[i]);  
    }
    ds1302writebytes(0x8e,0x80);
}

void readtime()
{
    miao=cmd_readbyte(r[0]);
    fen=cmd_readbyte(r[1]);
    shi=cmd_readbyte(r[2]); 
    zhou=cmd_readbyte(r[5]);
    ri=cmd_readbyte(r[3]);
    yue=cmd_readbyte(r[4]); 
    nian=cmd_readbyte(r[6]);    
}

void DS1302_SubMain(){
     
    //settime();//设置时间时,单独使用.设置完后,注释掉

    readtime();
}