#include "1wire_lcd.h"
#include "mbed.h"

DigitalOut wire(p21);


void one_wire(unsigned char data)
{
    char i;
    wire=1;
    for(i=0;i < 8;i++)
    {
        if((data<<(i))&0x80)
        {
            wire=0;
            wire=1;
        }
        else
        {
            wire=0;
            wait_us(15);
            wire=1;
            wait_us(30);
        }
    }
    wire=0;
    wait_us(210);
    wire=1;
    wait_us(300);
}


void lcd_putc(unsigned char c)
{
   unsigned char data;
    data = 0x00;
    data |=0x50;
    one_wire(data);
    data |= ((c & 0xF0)>>4);
    one_wire(data);
    data &= 0x1F;
    one_wire(data);
    wait_us(100);
    
    data = 0x00;
    data |= 0x50;
    one_wire(data);
    data |= (((c & 0x0F) << 4) >> 4);
    one_wire(data);
    data &= 0x1F;
    one_wire(data);
    wait_us(100);

}

void lcd_command(unsigned char c)
{
   unsigned char data;
    data = 0x00;
    data |=0x40;
    one_wire(data);
    data |= ((c & 0xF0)>>4);
    one_wire(data);
    data &= 0x0F;
    one_wire(data);
    wait_us(100);
    
    data = 0x00;
    data |= 0x40;
    one_wire(data);
    data |= (((c & 0x0F) << 4) >> 4);
    one_wire(data);
    data &= 0x0F;
    one_wire(data);
    wait_us(100);

}

void lcd_clear(void)
{
    lcd_command(0x1);
    wait_ms(2);
}

void lcd_position(unsigned char x,unsigned char y)
{
    if(x==1)
        lcd_command(0x80+((y-1)%20));
    else
        lcd_command(0xC0+((y-1)%20));
}

void lcd_printf(const char * a)
{
    wait_us(100);
    while(*a)
        lcd_putc(*a++);
}

void lcd_init()
{
    one_wire(0);
    wait_ms(15);
    lcd_command(0x02);
    wait_ms(2);
    lcd_command(40);    //2line 4bit
    lcd_command(6);     //write right
    lcd_command(12);    //pointer hidden
    lcd_clear();


    lcd_command(128);   //first line

}


