#ifndef SCREEN_H
#define SCREEN_H

#include "MicroBit.h"
#include "Sprite.h"

class Screen{
    private:
    MicroBit *m_ubit;
    uint8_t buf[5][5];
    public:
    Screen(MicroBit *ubit){
        m_ubit = ubit;
        clearBuffer();
    }
    void clearBuffer(){
        for(int row = 0; row < 5; row++)
            for(int col = 0; col < 5; col++)
                buf[row][col] = 0;
    }
    
    void draw(Sprite sprite){
        buf[sprite.getX()][sprite.getY()] = 255;
    }
    void refresh(){
        m_ubit->display.clear();
        for(int row = 0; row < 5; row++){
            for(int col = 0; col < 5; col++){
                m_ubit->display.image.setPixelValue(row, col, buf[row][col]);      
            }
        }
        clearBuffer();
    }
};

#endif