#include "MicroBit.h"
#include "Screen.h"
#include "Bullet.h"
#include "Spacecraft.h"
#include "Asteroid.h"

MicroBit ubit;
MicroBitSerial serial(USBTX, USBRX);

int main(){
    ubit.init();
    Screen screen(&ubit);
    
    Spacecraft spacecraft;
    Bullet bullet;
    Asteroid asteroid;

    bullet.setX(spacecraft.getX());
    bullet.setY(spacecraft.getY());
    
    int rnd = 6;
    rnd = ubit.random(5);
    
    asteroid.setX(rnd);
    asteroid.setY(0);    
    
    int dist;
    while(true){
        
        // move spacecraft
        rnd = ubit.random(9);
        if(rnd > 5)
            spacecraft.moveRight();
        else if(rnd < 3) 
            spacecraft.moveLeft();
        
        
        // move bullet
        for(int i = 0; i < 2; i++){
            if(bullet.getY() == 0)
                bullet.setX(spacecraft.getX());
            bullet.move();
            
            if(asteroid.hitBy(bullet)){
                screen.draw(bullet);
                screen.draw(spacecraft);
                screen.draw(asteroid);
                screen.refresh();
                release_fiber();
            }
            
            if(asteroid.getY() == 4){
                rnd = ubit.random(5);
                asteroid.setX(rnd);
                serial.send(asteroid.getX());
                serial.send(',');
                serial.send(rnd);
                serial.send("\n\r");
            }
            asteroid.move();
            
            if(asteroid.hitBy(bullet)){
                screen.draw(bullet);
                screen.draw(spacecraft);
                screen.draw(asteroid);
                screen.refresh();
                release_fiber();
            }
            
            ubit.sleep(200);
            
            screen.draw(bullet);
            screen.draw(spacecraft);
            screen.draw(asteroid);
            screen.refresh();
        }
        
    }  
    
    release_fiber();
}