/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Ahmed Hedait
Username: el16ah
Student ID Number: 201069879
Date:
*/


#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "MazeEngine.h"



N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
MazeEngine maze;



void render();
void welcome();



int main( )
{
    // INTIALISING THE LCD AND GAMEPAD.
    pad.init();
    lcd.init();
    maze.init();
    lcd.setContrast(0.4);
    lcd.normalMode();
    lcd.setBrightness(0.5);
    
    welcome();
    

    // game loop - read input, update the game state and render the display
    while (1) {
        maze.read_input(pad);
        maze.update(pad);
        render();
        wait(.04);
    }
}

// this function draws each frame on the LCD
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();
    maze.draw(lcd);
    lcd.refresh();
}

void welcome() {
    
    lcd.printString("The Great Maze",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();

    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}