#ifndef BALL_H
#define BALL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Ball Class
@author Ahmed Hedait, University of Leeds
@brief Controlling the ball of the Maze game.
@date May 2018
*/ 

class Ball
{
public:
    /** Constructor */
    Ball();
    
    /** Destructor */
    ~Ball();

    void init();
    
    /** Drawing of the ball */
    void draw(N5110 &lcd);
    
    /** Updating the directions of the Ball
    * @brief Moving the ball based on their new positions and assure their stay
    * @param circx - new x position (0-84)
    * @param circy - new y position (0-48) */
    void update(Direction dir);
    
    /** get the position of the ball 
    * @return the position of the ball 
    */
    Vector2D get_pos();
    
    /** check if the ball and the ball collides 
    * @brief Ball does not overlap the walls of the Maze. 
    */
    void check_wall_collision(Gamepad &pad);

private:

    int _circx;
    int _circy;
    int _speed;
    int _a;
    int _b;
    int _c;
    int _d;
};
#endif