#ifndef MAZEENGINE_H
#define MAZEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Maze.h"
#include "Ball.h"

/** MazeEngine Class
@author Ahmed Hedait, University of Leeds
@brief  When goal is reaches at end of the game.
@date May 2018
*/

class MazeEngine
{
public:

    /** Constructor */
    MazeEngine();

    /** Destructor */
    ~MazeEngine();

    void init();

    /** Read the inputs of the game.
    */
    void read_input(Gamepad &pad);

    /** Intialising the drawing of the ball and maze
    */
    void draw(N5110 &lcd);

    /** Updating when the ball goes through the opening hole
    * @brief Print out that the game is finished and re-start if needed
    * controlled within the Gamepad Joystick
    */
    void update(Gamepad &pad);

private:

    void check_goal(Gamepad &pad);
    void print_win(N5110 &lcd);
    void check_wall_collision(Gamepad &pad);

    Maze _maze;
    Direction _dir;
    Ball _ball;
    Vector2D ball_pos;

    int _a;
    int _b;
    int _c;
    int _d;

};
#endif