#include "MazeEngine.h"
// nothing doing in the constructor and destructor
MazeEngine::MazeEngine()
{

}

MazeEngine::~MazeEngine()
{

}

void MazeEngine::init()
{
    _ball.init();
}

void MazeEngine::read_input(Gamepad &pad)
{
    _dir = pad.get_direction();
    // printf("direction %i\n", _dir);
}

void MazeEngine::update(Gamepad &pad)
{
    _ball.check_wall_collision(pad);
    _ball.update(_dir);
    check_goal(pad);
}

void MazeEngine::draw(N5110 &lcd)
{
    // DRAW THE ELEMENTS OF MAZE.
    _maze.draw(lcd);

    // BALL DRAWING
    _ball.draw(lcd);

    /* HERE IS A SIMPLE CODE THAT WHEN THE BALL PASS THROUGH THE OPENING THEN THE SCREEN SHOULD BE CLEARED IN WHICH BRAVO IS PRINTED TO
    TELL THE USER THE GAME IS FINISHED. */
    if (ball_pos.x > 83 & ball_pos.y == 27) {
        print_win(lcd);
    }
}

// CHECK IF THE GOAL IS MET, AND GIVE THE USER ABILITY TO RESTART THE GAME AGAIN.
void MazeEngine::check_goal(Gamepad &pad)
{
    ball_pos = _ball.get_pos();
    if(ball_pos.x > 83 & ball_pos.y == 27) {
        if(pad.check_event(Gamepad::START_PRESSED) == true) {
            init();
        }
    }
}

// CHECK IF THE GOAL IS MET, AND PRINT OUT TO THE LCD SCREEN. 
void MazeEngine::print_win(N5110 &lcd)
{
    lcd.clear();
    lcd.printString("  WELL DONE!  ",3,2);
    lcd.printString("  Press Start ",0,4);
}