#include "mbed.h"
#include "QEI.h"


DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

PwmOut RMOTORA(PB_5);
PwmOut RMOTORB(PB_10);
PwmOut LMOTORA(PB_8);
PwmOut LMOTORB(PA_6);

QEI L_ENC(PA_0,PA_1,NC,100);
QEI R_ENC(PA_10,PB_3,NC,100);

AnalogIn _gyro(A2);
AnalogIn reciever(A3);

DigitalOut led1(PC_10);
DigitalOut led2(PC_11);


double angle = 0.0;
double gyro_cal = 3.3;

// Returns the yaw (clockwise) rotation in degrees-per-second reported by the LY3200 gyroscope.
double read_gyro ( void ){
    // Gyro is a ST Micro LY3200ALH Yaw-rate Gyro: 0.67mV / d.p.s, 1.5V offset 
    double offset = .4451;
    double r_gyro = (_gyro.read() - offset) * .67 / offset * 600;  // Offset of .4455 measured experimentally
    angle += r_gyro * .01;
    wait(.01); 
    return r_gyro;
}

void setLeftPwm(float speed) {
    if (speed == 0) {
        LMOTORA = 1.0;
        LMOTORB = 1.0;
    }
    
    if (speed > 0) {
        LMOTORA = speed;
        LMOTORB = 0;
    }
    else {
        LMOTORA = 0;
        LMOTORB = -speed;
    }
}

void setRightPwm(float speed) {
    if (speed == 0) {
        RMOTORA = 1.0;
        RMOTORB = 1.0;
    }
    
    if (speed > 0) {
        RMOTORA = speed;
        RMOTORB = 0;
    }
    else {
        RMOTORA = 0;
        RMOTORB = -speed;
    }
}

int main() {
    while(1){
        led2 = 1;
        led1 = 1;
        pc.printf("Hello World\n!");
    }
}
