#ifndef MOTORS_H
#define MOTORS_H

#include "QEI.h"

class Motor
{
public:
    Motor(PinName forward, PinName reverse, PinName encA, PinName encB) : 
       m_speed(0.0), m_forward(forward), m_reverse(reverse), m_enc(encA, encB, NC, 100)
    {
    };
    
    void setPwm(float speed);
    void addToPwm(float diff);
    void resetEncoder();
    float getFwd();
    float getRev();
    int getPulses();
    void setSpeed(float speed);
    void updateSpeed();
    float getSpeed();
private:
    float m_speed;
    PwmOut m_forward;
    PwmOut m_reverse;
    QEI m_enc;
};

#endif // MOTORS_H