#ifndef SENSORS_H
#define SENSORS_H

#include "pin_def.h"

class IRSensor
{
public:
    IRSensor(PinName emitter, PinName reciever) : 
        m_emitter(emitter), m_reciever(reciever) 
    {
    };
    double getValue();
private:
    DigitalOut m_emitter;
    AnalogIn   m_reciever;
};

class Gyro
{
public:
    Gyro(PinName pin) : m_pin(pin), m_angle(0) 
    {
        Ks=1;
    };
    
    void update();
    void reset();
    
    double getAngularVelocity();
    double getAngle();
private:
    AnalogIn m_pin;
    double m_angle;
    double Ks;
};

#endif // SESNORS_H

