#include "motors.h"

void Motor::setPwm(float speed)
{
    m_speed = speed;
    
    if(m_speed > 1.0)
        m_speed = 1.0;
    else if(m_speed < -1.0)
        m_speed  = -1.0;
        
    if(speed > 0){
        m_forward = m_speed;
        m_reverse = 0.0;
    }
    else if(speed < 0){
        m_reverse = -m_speed;
        m_forward = 0.0;
    }
    else{
        m_forward = 1.0;
        m_reverse = 1.0;
    }
}

void Motor::resetEncoder()
{
    m_enc.reset();
}

void Motor::addToPwm(float diff)
{
    m_speed += diff;
    setPwm(m_speed);
}

int Motor::getPulses()
{
    return m_enc.getPulses();
}

float Motor::getFwd(){
    
    return m_forward.read();
    }
    
    
float Motor::getRev(){
    
    return m_reverse.read();
    
    }

void Motor::setSpeed(float speed){
    
    m_speed=speed;
    
    
    }
    
    
float Motor::getSpeed(){
        return m_speed;
        
        
    }    

