#ifndef motionPlanning_H
#define motionPlanning_H

#include "generalFunctions.h"
#include "mbed.h"
#include "orion_pinmapping.h"
#include "config.h"
#include "math.h"


class motionPlanning
{
public:    
    motionPlanning();
    float plan[2], linearGain, obstacleDistance, largest, targetDistance[5], compareProgress, linearSpeed, bearingTT, imuTT, limit, limitFW, avgSum, prevRobotF, farthest, spent, count, angleCW, angleCCW;
    int sensorDir, rs, rs2, sFW, n, n0, CS, AOreverse, GTGreverse, rev, cheat;
    float kp, kd, GTGTrue;
    bool FW, Trap, s;
    char mode;
    float obsFWLX, obsFWLY, obsFWRX, obsFWRY, obs[5][2], obsRF[5][2], target[2], compareAngle;
    void planTrack(uint16_t max[5], 
                   float target[2], 
                   float local[2],
                   float dueXaxis,
                   float robotF, float Error, float time);
    
                       

private:
    float point; 
    float dueNorth, sensorAngle, theta;
    int sensorNo;
    float alpha;
    float Vmax, timeAllowed;
    float GTGTerm,kLin, sigma, cAO, kGTG, uGTG, AOTerm, c, kAO, epsilon, uAO;
    
    
    void followBoundary(uint16_t max[5], float local[2], float robotF, float time);
    void pTrack(uint16_t max[5], float local[2], float dueXaxis);
    void obstacleDist(uint16_t max[5]); 
    void wallTurn(float target[2], float local[2]);
    void GTSpeed(float target[2], float local[2]);
    void AOSpeed(int r, float local[2]);
    void clearShot(float target[2], float local[2], float dueXaxis);
    void trapped(uint16_t max[5], float robotF, float time);
};


#endif