 #include "pidBearing.h"

pidBearing::pidBearing()
    {
//        kp = 0.32;
//        kd = 20;
//        ki = 0.0;
    }

void pidBearing::setSpeedChange(float* wl, float* wr,
                                float mplan[2],
                                float local[2],
                                float yaw,
                                float* linearSpeed, int targetV, float kp, float kd, int GTG)
    {
            bTW = 90 - 180/M_PI * atan2((mplan[1]-local[1]),(mplan[0]-local[0])); //angle due X-axis of IMU
            
            if (bTW>=0.0) iTA = 360 - bTW; //Since YAW decreases in the clockwise direction, if target is to the right of IMU to achieve should be 360 minus the bearing to the waypoint
            else iTA = 0 - bTW; //Since YAW decreases in the anticlockwise direction, if target is to the left of IMU to acieve should 0 minus (negative sign) bearing to the waypoint
                
            offset = yaw - iTA; //this is to calculate how far off the bot is from it's current IMU yaw to the one it needs to be.
            
            if (offset >=180) aTR = offset - 360; //this is to determine the shortest angle to rotate.
            else aTR = offset - 0;
                
            if (generalFunctions::abs_f(aTR)>180) Error = 360 - generalFunctions::abs_f(aTR);
            else Error = aTR;
                
            sumError = sumError + Error;
              
            speedChange = -1 *(kd * (Error - prevError) + kp * (Error));
            prevError = Error;
            
            if (GTG == 1){
            Error = generalFunctions::abs_f(Error);
            Error = generalFunctions::constrain_f(Error, 0.1, 180);
            *linearSpeed = generalFunctions::constrain_f((*linearSpeed/Error)*80, 0, 17.5);}   
            
                        
            *wl =  -1 * targetV * (*linearSpeed - speedChange); // linear component - rotation component
            *wr =  -1 * targetV * (*linearSpeed + speedChange); // linear component + rotation component                
    }
    
    
    
void pidBearing::findRobotFrameDistance(float target[2], float local[2]) 
    {
        robotFrame = sqrt(pow((target[0] - local[0]),2) + pow((target[1] - local[1]),2));
    }