#include "MotionPlanning.h"


motionPlanning::motionPlanning()
    {limit = 350;
     limitFW = 280;//was 350
     
     Vmax = 17.5;; 
     alpha = 1; //for GTG
     
     c = 12000000;
     epsilon = 550000; //these numbers were determined in excel
     timeAllowed = 2.0;
     }


void motionPlanning::planTrack(uint16_t max[5], 
                               float target[2],
                               float local[2], 
                               float dueXaxis, //starting with extreme right sensor
                               float robotF, float Error, float time)

                               
                               
    {
    obstacleDist(max);
    //trapped(max, robotF, time);
        
//    if (obstacleDistance < limit && FW == false) mode = 'T';
//    else if (FW == true) mode = 'F';
//    else mode = 'G';
      mode = 'G';    
      
        switch(mode) { 
           case 'F'://Follow
                clearShot(target, local, dueXaxis);
                if (max[CS] > limitFW && compareProgress > robotF) {FW = false;}
                else {
                            n = 0;                                 
                            pTrack(max, local, dueXaxis);
                            followBoundary(max, local, robotF, time);
                            
                                switch(n0) {
                                    case -90://LV
                                       if (rs == 2) n = n0, sFW = 2;
                                       else if (rs > 2) n = angleCW, sFW = 4;
                                       else if (rs < 2 && angleCCW > 0) n = angleCCW, sFW = 0;
                                       break;                                    
                                    case 90://LV            
                                       if (rs == 2) n = n0, sFW = 2;
                                       else if (rs < 2) n = angleCCW, sFW = 0;
                                       else if (rs > 2 && angleCW < 0) n = angleCW, sFW = 4; 
                                       break;                                           
                                        }
                                                        
                                
                                                            
                            pTrack(max, local, dueXaxis);
                            AOSpeed(sFW, local);
                
                            plan[0] = obs[2][0];
                            plan[1] = obs[2][1];                                     
                     }
                break;              
                
           case 'T'://Turn
                if(rs > 2 || (rs==2 && rs2 < 2 /*Error >0*/)) n = -90;//LV//-90; //clockwise
                else if (rs < 2 || (rs==2 && rs2 > 2/*Error <0*/)) n = 90;//LV//90; //counter-clockwise
                
                wallTurn(target,local);
                pTrack(max, local, dueXaxis);
                AOSpeed(rs, local);


                plan[0] = obs[rs][0];
                plan[1] = obs[rs][1];
                
                
                break; 
                
           case 'G'://Goal
                GTSpeed(target,local);                                                                           
                plan[0] = target[0];//target[0];
                plan[1] = target[1];//target[1];
                break;     
       
                       
        }                                                                                
    }
    
    
void motionPlanning::pTrack(uint16_t max[5],
                               float local[2], 
                               float dueXaxis) {
                                                                                                                               
            
              for (int r = 0; r < 5; r++)
              {                
                    point = generalFunctions::constrain_f(max[r], 40, 500);
                    
                    /*0 for 0th, 45 for 1st and so on ending with 180 for 4th in Robot Frame*/                 
                    sensorAngle =  (45*r);
                               
                    /*dueXaxis by itself is the deviation of the 0th sensor from the X axis of global frame
                    e.g. if 0th sensor is 270 degrees from X axis then 1st is 315, 2nd is 0, 3rd is 45 and 4th is 90 all in global frame and cc about X axis
                   
                    n can be -90 or 90 depending on which direction to rotate*/ 
                    float sensorAngleGlobal =  (dueXaxis + 45*(r) + n);
                    if (sensorAngleGlobal > 360){
                        sensorAngleGlobal = sensorAngleGlobal - 360;}
                    
                                            
                    /*in global frame the waypoint is at right angles (if n != 0) to the obstacle set using sensorAngleGlobal and the distance of the obstacle*/                                            
                    obs[r][0] =  local[0] + point*cos(sensorAngleGlobal*(M_PI/180)); 
                    obs[r][1] =  local[1] + point*sin(sensorAngleGlobal*(M_PI/180));

                    /*in robot frame*/                                            
                    obsRF[r][0] =  point*cos(sensorAngle*(M_PI/180)); 
                    obsRF[r][1] =  point*sin(sensorAngle*(M_PI/180));
                                                                               
              }                           
    }
        

void motionPlanning::obstacleDist(uint16_t max[5]) {
                              
               /*compare all sensor readings for the one with the closest obstacle*/
               obstacleDistance = limit;
               for (int a = 0; a < 5; a++){                                      
                   if  (max[a] < obstacleDistance){
                                rs = a;
                                obstacleDistance = max[a];}
                    }
                    
               farthest = 0;
               for (int b = 0; b < 5; b++){                                      
                   if  (max[b] > farthest){
                                rs2 = b;
                                farthest = max[b];}
                    }     
                     
    
    }

void motionPlanning::wallTurn(float target[2], 
                               float local[2]) {
            
            n0 = n; //remember which direction I turned to follow wall
            compareProgress = sqrt(pow((target[0] - local[0]),2) + pow((target[1] - local[1]),2)); //to compare and determine whether to keep following wall or go-to-goal
            FW = true; //set to determine robot mode          
}


void motionPlanning::GTSpeed(float target[2], float local[2]){
                
                
            /***____________________________________***/
            /*determine linear speed for Go-To-Goal*/            
            float RF = sqrt(pow((target[0] - local[0]),2) + pow((target[1] - local[1]),2));  //distance between target         
            
            //Go To Goal 
            GTGTerm = -1*alpha*(pow((RF/1000),2));
            kGTG = ( Vmax * (1-exp(GTGTerm)))/(RF);
            uGTG = kGTG * (RF);
                                       
//            if (RF <= 30)
//                linearSpeed = 0.0;
//            else
            linearSpeed = uGTG;               
            linearSpeed = generalFunctions::constrain_f(linearSpeed, Vmax*0.5, Vmax); 
            
            kp = 1.0;
            kd = 26; 
            GTGTrue = 1;                    
            /***____________________________________***/           
            }

void motionPlanning::AOSpeed(int r, float local[2]){
                
                
            /***____________________________________***/
            /*determine linear speed for Avoid Obstacle.*/            
            float e = sqrt(pow((obs[r][0] - local[0]),2) + pow((obs[r][1] - local[1]),2));  //distance from obstacle to robot         
            
            AOTerm = c/(e*e + epsilon); 
            kAO = (1/e) * AOTerm;
            uAO = kAO * e;
            
            linearSpeed = uAO;
            
            kp = linearSpeed/80;// change to 90 for normal floor;
            kp = generalFunctions::constrain_f(kp, 0.2, 1.0);
            kd = 26;// change to 22 for normal floor;
            GTGTrue = 1;//was 0            
            /***____________________________________***/ 
            
            
            }   

void motionPlanning::clearShot(float target[2], float local[2], float dueXaxis){
                    
            bearingTT = 180/M_PI * atan2((target[1]-local[1]),(target[0]-local[0])); //angle due X-axis of IMU
                            
            if (bearingTT > 337.5 || bearingTT < 22.5) bearingTT = 0;                
                
                
            //find the sensor facing imuToTarget
            for (int r = 0; r < 5; r++){
                float sensorCS =  (dueXaxis + 45*r);
                
                if (sensorCS > 360){
                sensorCS = sensorCS - 360;} 
                               
                if (sensorCS < bearingTT+22.5 && sensorCS > bearingTT-22.5){CS = r; r = 5;}
                else {CS = 5;} 
                }    
    }                               


    
    
void motionPlanning::followBoundary(uint16_t max[5], float local[2], float robotF, float time){
                                                                                  
        obsFWRX = obsRF[1][0] - (obsRF[0][0] - (max[0] - limitFW)); 
        obsFWRY = obsRF[1][1] - obsRF[0][1];        
        angleCCW = -1*(90 - 180/M_PI * atan2(obsFWRY, obsFWRX)); 
                                                                            
        obsFWLX = obsRF[3][0] - (obsRF[4][0] + (max[4] - limitFW)); 
        obsFWLY = obsRF[3][1] - obsRF[4][1];        
        angleCW = -1*(90 - 180/M_PI * atan2(obsFWLY, obsFWLX));                              
}