#ifndef odometer_H
#define odometer_H

#include "mbed.h"
#include "generalFunctions.h"
#include "QEI.h"
#include "config.h"
#include "orion_pinmapping.h"


class odometer
{
public:
    odometer();
    void update();
    void init();
    //void getRevolutions(float *revolutions[2]);
    //void getRPM(float *rpm[2]);
    
    float revolutions[2];
    float rpm[2];
    
private:
    QEI encLeft;
    QEI encRight;
    
    Timer enc_timer;
    float timer_s;
    
    uint16_t movWindow_len;
    uint16_t movWindow_index;
    float encRes;
    
    static const unsigned int movWindow_lenMax = 64; //to prevent excessive RAM usage at program runtime
    
    int32_t pulse_counter[2][2]; // [0:left / 1:right], [0:previous / 1:current]
    float rpmWindow_left[movWindow_lenMax]; // [movWindow_index: instantaneous velocity in rpm]
    float rpmWindow_right[movWindow_lenMax]; // [movWindow_index: instantaneous velocity in rpm]
    
    float filtered_reading[2][2]; // [0:left / 1:right], [0:revolutions / 1:velocity in rpm]
};


#endif