#include "mbed.h"
#include "CAN.h"
 
Ticker ticker; //interupt setup
DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can1(p9, p10); //set can channel
CAN *canPointer;
int Send_Data; //Can data to send
Serial pc(USBTX, USBRX); // setup serial on computer
int Co = 0; // filter swapping counter
int f1,f2,h1;  // filters

 

// Function to send messges on the can bus
/* 
void send() {
    pc.printf("send()\n\r");
    if(can1.write(CANMessage(1337, &Send_Data, 1))) { //if a messges is sent print its value to serial
        pc.printf("wloop()\n\r");
        pc.printf("Message sent: %d\n\r", Send_Data);
    } 
    led1 = !led1;
}
*/

// fiter function to filter specific Can id's 
/*void Filter()
{
    if(Co == 0)
    {
    pc.printf("Filter 1\n\r");
    f1 = can1.filter(372, 256, CANStandard);
    
    } 
    if(Co == 1)
    {
    pc.printf("Filter 2\n\r");
    f1=can1.filter(376, 256, CANStandard);
    
    }  
    if(Co == 2)
    {
    pc.printf("Filter 3\n\r");
    f1=can1.filter(380, 256, CANStandard);
    Co=-1;
    }    
    Co ++;
}
*/

// main code
int main() 
{
    //initial setup
        canPointer = &can1;
        canPointer -> reset();
        f1 = canPointer -> filter(0x178, 0xff, CANAny); // filter setup, filter out can id 376 with mask 255, only allows 376 through
        //ticker.attach(&Filter, 0.5); // attach the filter swap to an interruprt that runs every half a second
        //ticker.attach(&send, 1); // attach the send function to an interrupt that runs every seconf
        CANMessage msg; 
        pc.baud (115200); // baud rate of serial to pc
        can1.frequency(500000);
        // all Var's for reading sensor data
        int Yaw_Byte1, Yaw_Byte2, Yaw, Y_Acc_Byte1, Y_Acc_Byte2, Y_Acc, Roll_Byte1, Roll_Byte2, Roll, X_Acc_Byte1, X_Acc_Byte2, X_Acc, Z_Acc_Byte1, Z_Acc_Byte2, Z_Acc;
    
    // constant loop
        while(1) 
        {
            pc.printf("loop()\n\r"); //show your at the top of the loop
            if(can1.read(msg,f1))    // if a can messege can be read then assign all of the data
            {   
                if(msg.id == 372 && Co==1)
                {
                    Yaw_Byte1 = msg.data[0];
                    Yaw_Byte2 = msg.data[1]<<8; // shift right to normailse the second byte of data, same with others 
                    Y_Acc_Byte1 = msg.data[4];
                    Y_Acc_Byte2 = msg.data[5]<<8; //^
                }
                if(msg.id == 376 && Co==2)
                {
                    Roll_Byte1 = msg.data[0];
                    Roll_Byte2 = msg.data[1]<<8; //^
                    X_Acc_Byte1 = msg.data[4];
                    X_Acc_Byte2 = msg.data[5]<<8; //^
                }
                if(msg.id == 380 && Co==3)
                {
                    Z_Acc_Byte1 = msg.data[4];
                    Z_Acc_Byte2 = msg.data[5]<<8; //^
                    Co = 0;
                }
                //Calculate actual data by adding both bytes and the offset anf then normalising
                Yaw = (Yaw_Byte1 + Yaw_Byte2 - 32768)*0.005;
                Y_Acc = (Y_Acc_Byte1 + Y_Acc_Byte2 - 32768)*0.0001274;
                Roll = (Roll_Byte1 + Roll_Byte2 - 32768)*0.005;
                X_Acc = (X_Acc_Byte1 + X_Acc_Byte2 - 32768)*0.0001274;
                Z_Acc = (Z_Acc_Byte1 + Z_Acc_Byte2 - 32768)*0.0001274;
               
                // show the id of the messege being read 
                pc.printf("Message received: %d\n\r", msg.id);
                // print all of the data to pc serial
                pc.printf("Yaw: %d\n\r", Yaw); 
                pc.printf("Roll: %d\n\r", Roll); 
                pc.printf("Y_Acc: %d\n\r", Y_Acc); 
                pc.printf("X_Acc: %d\n\r", X_Acc); 
                pc.printf("Z_Acc: %d\n\r", Z_Acc);   
                led2 = !led2;
                Co++;
            } 
            wait(0.01);
        }
}