#include "mbed.h"
#include "mDot.h"
#include "CommandTerminal.h"
#include "ATSerial.h"
#include "ATSerialFlowControl.h"
 
#define SERIAL_BUFFER_SIZE 512
 
//mts::ATSerial debug(USBTX, USBRX);
Serial debug(XBEE_DOUT, XBEE_DIN);
 
int main()
{
    debug.baud(115200);
 
    mDot* dot = mDot::getInstance();
 
    // Seed the RNG
    srand(dot->getRadioRandom());
 
    //Create pointer to ATSerial class
    mts::ATSerial* serial;
 
    if (dot->getFlowControl())
        //if MDOT_OK set serial to be connected to DB9 pin
        serial = new mts::ATSerialFlowControl(XBEE_DOUT, XBEE_DIN, XBEE_RTS, XBEE_CTS, SERIAL_BUFFER_SIZE, SERIAL_BUFFER_SIZE);
    else
        //Else if not MDOT_OK set ATSerial class pointer to 
        serial = new mts::ATSerial(USBTX, USBRX, SERIAL_BUFFER_SIZE, SERIAL_BUFFER_SIZE);
 
    debug.baud(dot->getDebugBaud());
    serial->baud(dot->getBaud());
 
    //Create object form CommandTerminal.cpp using constructor 
    //CommandTerminal(mts::ATSerial& serial, mDot* dot)
    CommandTerminal term(*serial, dot);
 
    term.start();
}