#include "CmdWakeMode.h"

CmdWakeMode::CmdWakeMode(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Wake Mode", "AT+WM", "Wakeup mode, INTERRUPT uses DIO7 as wake-up pin (0:INTERVAL,1:INTERRUPT,2:INTERVAL_OR_INTERRUPT)"),
        _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0:INTERVAL,1:INTERRUPT,2:INTERVAL_OR_INTERRUPT)";
    _queryable = true;
}

uint32_t CmdWakeMode::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("%s: ", name());

        _serial.writef("%lu\r\n", _dot->getWakeMode());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int mode;
        sscanf(args[1].c_str(), "%d", &mode);

        if ((code = _dot->setWakeMode(mode)) != mDot::MDOT_OK) {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdWakeMode::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;
    
    if (args.size() == 2) {
        int mode;
        if (sscanf(args[1].c_str(), "%d", &mode) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (mode != 0 && mode != 1 && mode != 2) {
            setErrorMessage("Invalid mode, expects (0:INTERVAL,1:INTERRUPT,2:INTERVAL_OR_INTERRUPT)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
