#include "CmdWakeInterval.h"

CmdWakeInterval::CmdWakeInterval(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Wake Interval", "AT+WI", "Wakeup interval (seconds)"),
        _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(2-2147483647) s";
    _queryable = true;
}

uint32_t CmdWakeInterval::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("%s: ", name());

        _serial.writef("%lu\r\n", _dot->getWakeInterval());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int timeout;
        sscanf(args[1].c_str(), "%d", &timeout);

        if ((code = _dot->setWakeInterval(timeout)) != mDot::MDOT_OK) {
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdWakeInterval::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;
    
    if (args.size() == 2) {
        int timeout;
        if (sscanf(args[1].c_str(), "%d", &timeout) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (timeout < 2 || timeout > INT_MAX) {
            setErrorMessage("Invalid interval, expects (2-2147483647) s");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
