#include "CmdTxWait.h"

CmdTxWait::CmdTxWait(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Tx Wait", "AT+TXW", "Enable/disable waiting for rx windows to expire after send. (0: off, 1: on)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0,1)";
    _queryable = true;
}

uint32_t CmdTxWait::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Tx wait: ");

        _serial.writef("%u\r\n", _dot->getTxWait());
    }
    else if (args.size() == 2)
    {
        int32_t code;

        if ((code = _dot->setTxWait(args[1] == "1")) != mDot::MDOT_OK)
        {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdTxWait::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        if (args[1] != "0" && args[1] != "1") {
            setErrorMessage("Invalid parameter, expects (0: off, 1: on)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
