#include "CmdSessionDataRate.h"

CmdSessionDataRate::CmdSessionDataRate(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Session Data Rate", "AT+SDR", "Get the current datarate"),
  _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _queryable = true;
}

uint32_t CmdSessionDataRate::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("Session Data Rate: ");

        _serial.writef("%s\r\n", mDot::DataRateStr(_dot->getSessionDataRate()).c_str());
    }


    return 0;
}

bool CmdSessionDataRate::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    setErrorMessage("Invalid arguments");
    return false;
}
