#include "CmdRxDataRate.h"

CmdRxDataRate::CmdRxDataRate(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Rx Data Rate", "AT+RXDR", "Set the Rx datarate, testing purposes only"),
  _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    if (_dot->getFrequencyBand() == mDot::FB_915)
        _usage = "(7-10|DR0-DR4|DR8-DR13)";
    else
        _usage = "(7-12|DR0-DR7)";

    _queryable = true;
}

uint32_t CmdRxDataRate::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("Rx Data Rate: ");

        _serial.writef("%s\r\n", mDot::DataRateStr(_dot->getRxDataRate()).c_str());
    }
    else if (args.size() == 2) {
        std::string dr = mts::Text::toUpper(args[1]);
        int32_t code;
        int datarate = 0;
        uint8_t i;

        int res = sscanf(dr.c_str(), "%d", &datarate);

        if (res == 0) {
            for (i = 0; i < 24; i++) {
                if (mDot::DataRateStr(i).find(dr) != std::string::npos) {
                    datarate = i;
                    break;
                }
            }
        } else {
            if (datarate > 6) {
                // Convert SF to DR
                if (_dot->getFrequencyBand() == mDot::FB_915) {
                    datarate = 10 - datarate;
                } else {
                    datarate = 12 - datarate;
                }
            }
        }

        if ((code = _dot->setRxDataRate(datarate)) != mDot::MDOT_OK) {
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdRxDataRate::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {
        std::string dr = mts::Text::toUpper(args[1]);

        uint8_t i;
        int datarate = -1;

        int res = sscanf(dr.c_str(), "%d", &datarate);

        if (res == 0) {
            for (i = 0; i < 24; i++) {
                if (mDot::DataRateStr(i).find(dr) != std::string::npos) {
                    datarate = i;
                    break;
                }
            }
        } else {
            if (_dot->getFrequencyBand() == mDot::FB_915 && datarate > 10) {
                datarate = -1;
            } else if (_dot->getFrequencyBand() == mDot::FB_868 && datarate > 12) {
                datarate = -1;
            } else if (datarate > 6) {
                // Convert SF to DR
                if (_dot->getFrequencyBand() == mDot::FB_915) {
                    datarate = 10 - datarate;
                } else {
                    datarate = 12 - datarate;
                }
            }
        }

        if (_dot->getFrequencyBand() == mDot::FB_915) {
            // DR8-13 used for P2P modes
            if (datarate < 0 || datarate > 13 || (datarate >= 5 && datarate <= 7)) {
                setErrorMessage("Invalid data rate, expects (7-10|DR0-DR4|DR8-DR13)");
                return false;
            }
        } else {
            if (datarate < 0 || datarate > 7) {
                setErrorMessage("Invalid data rate, expects (7-12|DR0-DR7)");
                return false;
            }
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
