#include "CmdFrequencyBand.h"

CmdFrequencyBand::CmdFrequencyBand(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Frequency Band", "AT+FREQ", "Configured Frequency Band '868' or '915'"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(868,915)";
    _queryable = true;
}

uint32_t CmdFrequencyBand::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Frequency Band: ");

        _serial.writef("%s\r\n", mDot::FrequencyBandStr(_dot->getFrequencyBand()).c_str());
    }

    return 0;
}

bool CmdFrequencyBand::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    setErrorMessage("Invalid arguments");
    return false;
}
