#include "CmdDebugBaudRate.h"

CmdDebugBaudRate::CmdDebugBaudRate(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Debug Baud Rate", "AT+DIPR", "Set debug serial baud rate, default: 115200 "), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(2400,4800,9600,19200,38400,57600,115200,230400,460800,921600)";
    _queryable = true;
}

uint32_t CmdDebugBaudRate::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Debug Baud Rate: ");

        _serial.writef("%lu\r\n", _dot->getDebugBaud());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int baudrate = 0;

        sscanf(args[1].c_str(), "%d", &baudrate);

        if ((code = _dot->setDebugBaud(baudrate)) == mDot::MDOT_OK) {
            _serial.writef("Set Debug Baud Rate: %d\r\n", baudrate);
        } else {
            
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdDebugBaudRate::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {
        int baudrate;

        if (sscanf(args[1].c_str(), "%d", &baudrate) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
