#include "CmdWakePin.h"

CmdWakePin::CmdWakePin(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Wake Pin", "AT+WP", "Wakeup DIO pin of sleep mode (1-8) (default: DI8, 1:DIN), deep-sleep uses DIO7"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(1-8)";
    _queryable = true;
}

uint32_t CmdWakePin::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        if (_dot->getVerbose())
            _serial.writef("%s: ", name());

        _serial.writef("%s\r\n", mDot::pinName2Str(_dot->getWakePin()).c_str());
    } else if (args.size() == 2) {
        int pin;
        sscanf(args[1].c_str(), "%d", &pin);

        _dot->setWakePin(mDot::pinNum2Name(pin));
    }

    return 0;
}

bool CmdWakePin::verify(std::vector<std::string> args) {
    if (args.size() == 1)
        return true;

    if (args.size() == 2) {
        int pin;
        if (sscanf(args[1].c_str(), "%d", &pin) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (pin < 1 || pin > 8) {
            setErrorMessage("Invalid pin, expects (1-8)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}
