#include "CmdTxPower.h"

CmdTxPower::CmdTxPower(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Tx Power", "AT+TXP", "Set the radio TX power before antenna gain in dBm"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0-20)";
    _queryable = true;
}

uint32_t CmdTxPower::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Tx Power: ");

        _serial.writef("%lu\r\n", _dot->getTxPower());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        int power = 0;
        sscanf(args[1].c_str(), "%d", &power);

        if ((code = _dot->setTxPower(power)) != mDot::MDOT_OK)
        {
            setErrorMessage(_dot->getLastError());;
            return 1;
        }
    }

    return 0;
}

bool CmdTxPower::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        int power = 0;
        if (sscanf(args[1].c_str(), "%d", &power) != 1) {
            setErrorMessage("Invalid argument");
            return false;
        }

        if (power < 0 || power > 20)
        {
            setErrorMessage("Invalid power, expects (0-20)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}

